/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteConverterTest {
    private static final String NEWLINE = System.getProperty("line.separator");

    @Test
    public void testByte() {
        Map models = ModelConverters.getInstance().read(ByteConverterModel.class);
        String json = "{   \"ByteConverterModel\":{      \"type\":\"object\",      \"properties\":{         \"myBytes\":{            \"type\":\"array\",            \"items\":{               \"type\":\"string\",               \"format\":\"byte\"            }         }      }   }}";
        SerializationMatchers.assertEqualsToJson(models, "{   \"ByteConverterModel\":{      \"type\":\"object\",      \"properties\":{         \"myBytes\":{            \"type\":\"array\",            \"items\":{               \"type\":\"string\",               \"format\":\"byte\"            }         }      }   }}");
    }

    @Test
    public void testByteProperty() {
        ModelImpl model = new ModelImpl().property("byteProperty", (Property)new ByteArrayProperty());
        Assert.assertEquals((String)Json.pretty((Object)model), (String)("{" + NEWLINE + "  \"properties\" : {" + NEWLINE + "    \"byteProperty\" : {" + NEWLINE + "      \"type\" : \"string\"," + NEWLINE + "      \"format\" : \"byte\"" + NEWLINE + "    }" + NEWLINE + "  }" + NEWLINE + "}"));
    }

    @Test
    public void testDeserializeByteProperty() throws Exception {
        String json = "{\n  \"properties\" : {\n    \"byteProperty\" : {\n      \"type\" : \"string\",\n      \"format\" : \"byte\"\n    }\n  }\n}";
        Model model = (Model)Json.mapper().readValue(json, Model.class);
        Json.prettyPrint((Object)model);
    }

    @Test
    public void testByteArray() {
        ModelImpl model = new ModelImpl().property("byteArray", (Property)new ArrayProperty((Property)new BinaryProperty()));
        Assert.assertEquals((String)Json.pretty((Object)model), (String)("{" + NEWLINE + "  \"properties\" : {" + NEWLINE + "    \"byteArray\" : {" + NEWLINE + "      \"type\" : \"array\"," + NEWLINE + "      \"items\" : {" + NEWLINE + "        \"type\" : \"string\"," + NEWLINE + "        \"format\" : \"binary\"" + NEWLINE + "      }" + NEWLINE + "    }" + NEWLINE + "  }" + NEWLINE + "}"));
    }

    class ByteConverterModel {
        public Byte[] myBytes = new Byte[0];

        ByteConverterModel() {
        }
    }
}

