/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HiddenFieldTest {
    @Test(description="it should ignore a hidden field")
    public void testHiddenField() {
        Map models = ModelConverters.getInstance().read(ModelWithHiddenFields.class);
        Model model = (Model)models.get("ModelWithHiddenFields");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((int)model.getProperties().size(), (int)2);
        Property idValue = (Property)model.getProperties().get("id");
        Assert.assertTrue((boolean)(idValue instanceof LongProperty));
        Assert.assertTrue((boolean)idValue.getRequired());
        Property nameValue = (Property)model.getProperties().get("name");
        Assert.assertTrue((boolean)(nameValue instanceof StringProperty));
    }

    class ModelWithHiddenFields {
        @ApiModelProperty(required=true)
        public Long id = null;
        @ApiModelProperty(required=true, hidden=false)
        public String name = null;
        @ApiModelProperty(hidden=true)
        public String password = null;

        ModelWithHiddenFields() {
        }
    }
}

