/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MapPropertyDeserializerTest {
    private static final String json = "{  \"tags\": [\"store\"],  \"summary\": \"Returns pet inventories by status\",  \"description\": \"Returns a map of status codes to quantities\",  \"operationId\": \"getInventory\",  \"produces\": [\"application/json\"],  \"parameters\": [],  \"responses\": {    \"200\": {      \"description\": \"successful operation\",      \"schema\": {        \"type\": \"object\",        \"x-foo\": \"vendor x\",        \"additionalProperties\": {          \"type\": \"integer\",          \"format\": \"int32\"        }      }    }  },  \"security\": [{    \"api_key\": []  }]}";

    @Test(description="it should deserialize a response per #1349")
    public void testMapDerserilization() throws Exception {
        Operation operation = (Operation)Json.mapper().readValue(json, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property responseSchema = response.getSchema();
        Assert.assertNotNull((Object)responseSchema);
        Assert.assertTrue((boolean)(responseSchema instanceof MapProperty));
        MapProperty mp = (MapProperty)responseSchema;
        Assert.assertTrue((boolean)(mp.getAdditionalProperties() instanceof IntegerProperty));
    }

    @Test(description="vendor extensions should be included with object type")
    public void testMapDeserilizationVendorExtensions() throws Exception {
        Operation operation = (Operation)Json.mapper().readValue(json, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property responseSchema = response.getSchema();
        Assert.assertNotNull((Object)responseSchema);
        MapProperty mp = (MapProperty)responseSchema;
        Assert.assertTrue((mp.getVendorExtensions().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull(mp.getVendorExtensions().get("x-foo"));
        Assert.assertEquals(mp.getVendorExtensions().get("x-foo"), (Object)"vendor x");
    }
}

