/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Cat;
import io.swagger.models.ClientOptInput;
import io.swagger.models.Employee;
import io.swagger.models.EmptyModel;
import io.swagger.models.JacksonReadonlyModel;
import io.swagger.models.JodaDateTimeModel;
import io.swagger.models.Model;
import io.swagger.models.Model1155;
import io.swagger.models.ModelImpl;
import io.swagger.models.ModelPropertyName;
import io.swagger.models.ModelWithAltPropertyName;
import io.swagger.models.ModelWithApiModel;
import io.swagger.models.ModelWithEnumArray;
import io.swagger.models.ModelWithFormattedStrings;
import io.swagger.models.ModelWithNumbers;
import io.swagger.models.ModelWithTuple2;
import io.swagger.models.Person;
import io.swagger.models.composition.AbstractModelWithApiModel;
import io.swagger.models.composition.ModelWithUrlProperty;
import io.swagger.models.composition.Pet;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelConverterTest {
    private Map<String, Model> read(Type type) {
        return ModelConverters.getInstance().read(type);
    }

    private Map<String, Model> readAll(Type type) {
        return ModelConverters.getInstance().readAll(type);
    }

    private void assertEqualsToJson(Object objectToSerialize, String fileName) throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), fileName);
        SerializationMatchers.assertEqualsToJson(objectToSerialize, json);
    }

    @Test(description="it should convert a model")
    public void convertModel() throws IOException {
        this.assertEqualsToJson(this.read((Type)((Object)Person.class)), "Person.json");
    }

    @Test(description="it should convert a model with Joda DateTime")
    public void convertModelWithJodaDateTime() throws IOException {
        this.assertEqualsToJson(this.read((Type)((Object)JodaDateTimeModel.class)), "JodaDateTimeModel.json");
    }

    @Test(description="read an interface")
    public void readInterface() throws IOException {
        this.assertEqualsToJson(this.readAll((Type)((Object)Pet.class)), "Pet.json");
    }

    @Test(description="it should read an inherited interface")
    public void readInheritedInterface() throws IOException {
        this.assertEqualsToJson(this.readAll((Type)((Object)Cat.class)), "Cat.json");
    }

    @Test(description="it should honor the ApiModel name")
    public void honorApiModelName() {
        Map<String, Model> schemas = this.readAll((Type)((Object)ModelWithApiModel.class));
        Assert.assertEquals((int)schemas.size(), (int)1);
        String model = schemas.keySet().iterator().next();
        Assert.assertEquals((String)model, (String)"MyModel");
    }

    @Test(description="it should override an inherited model's name")
    public void overrideInheritedModelName() {
        Map<String, Model> rootSchemas = this.readAll((Type)((Object)AbstractModelWithApiModel.class));
        Assert.assertEquals((int)rootSchemas.size(), (int)3);
        Assert.assertTrue((boolean)rootSchemas.containsKey("MyProperty"));
        Assert.assertTrue((boolean)rootSchemas.containsKey("ModelWithUrlProperty"));
        Assert.assertTrue((boolean)rootSchemas.containsKey("ModelWithValueProperty"));
        Map<String, Model> nestedSchemas = this.readAll((Type)((Object)ModelWithUrlProperty.class));
        Assert.assertEquals((int)nestedSchemas.size(), (int)1);
        Assert.assertTrue((boolean)nestedSchemas.containsKey("MyProperty"));
    }

    @Test(description="it should maintain property names")
    public void maintainPropertyNames() {
        Map<String, Model> schemas = this.readAll((Type)((Object)ModelPropertyName.class));
        Assert.assertEquals((int)schemas.size(), (int)1);
        String modelName = schemas.keySet().iterator().next();
        Assert.assertEquals((String)modelName, (String)"ModelPropertyName");
        Model model = schemas.get(modelName);
        Iterator itr = new TreeSet(model.getProperties().keySet()).iterator();
        Assert.assertEquals((String)((String)itr.next()), (String)"gettersAndHaters");
        Assert.assertEquals((String)((String)itr.next()), (String)"is_persistent");
    }

    @Test(description="it should serialize a parameterized type per 606")
    public void serializeParameterizedType() {
        Map<String, Model> schemas = this.readAll((Type)((Object)Employee.class));
        ModelImpl employee = (ModelImpl)schemas.get("employee");
        Map props = employee.getProperties();
        Iterator et = props.keySet().iterator();
        Property id = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(id instanceof IntegerProperty));
        Property firstName = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(firstName instanceof StringProperty));
        Property lastName = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(lastName instanceof StringProperty));
        Property department = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(department instanceof RefProperty));
        Property manager = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(manager instanceof RefProperty));
        Property team = (Property)props.get(et.next());
        Assert.assertTrue((boolean)(team instanceof ArrayProperty));
        ArrayProperty ap = (ArrayProperty)team;
        Assert.assertTrue((boolean)ap.getUniqueItems());
        Assert.assertNotNull((Object)employee.getXml());
        Assert.assertEquals((String)employee.getXml().getName(), (String)"employee");
    }

    @Test(description="it should ignore hidden fields")
    public void ignoreHiddenFields() {
        Map<String, Model> schemas = this.readAll((Type)((Object)ClientOptInput.class));
        Model model = schemas.get("ClientOptInput");
        Assert.assertEquals((int)model.getProperties().size(), (int)2);
    }

    @Test(description="it should set readOnly per #854")
    public void setReadOnly() {
        Map<String, Model> schemas = this.readAll((Type)((Object)JacksonReadonlyModel.class));
        ModelImpl model = (ModelImpl)schemas.get("JacksonReadonlyModel");
        Property prop = (Property)model.getProperties().get("count");
        Assert.assertTrue((boolean)prop.getReadOnly());
    }

    @Test(description="it should process a model with org.apache.commons.lang3.tuple.Pair properties")
    public void processModelWithPairProperties() {
        ModelWithTuple2.TupleAsMapModelConverter asMapConverter = new ModelWithTuple2.TupleAsMapModelConverter(Json.mapper());
        ModelConverters.getInstance().addConverter((ModelConverter)asMapConverter);
        Map<String, Model> asMap = this.readAll((Type)((Object)ModelWithTuple2.class));
        ModelConverters.getInstance().removeConverter((ModelConverter)asMapConverter);
        Assert.assertEquals((int)asMap.size(), (int)4);
        for (String item : Arrays.asList("MapOfString", "MapOfComplexLeft")) {
            ModelImpl model = (ModelImpl)asMap.get(item);
            Assert.assertEquals((String)model.getType(), (String)"object");
            Assert.assertNull((Object)model.getProperties());
            Assert.assertNotNull((Object)model.getAdditionalProperties());
        }
        ModelWithTuple2.TupleAsMapPropertyConverter asPropertyConverter = new ModelWithTuple2.TupleAsMapPropertyConverter(Json.mapper());
        ModelConverters.getInstance().addConverter((ModelConverter)asPropertyConverter);
        Map<String, Model> asProperty = this.readAll((Type)((Object)ModelWithTuple2.class));
        ModelConverters.getInstance().removeConverter((ModelConverter)asPropertyConverter);
        Assert.assertEquals((int)asProperty.size(), (int)2);
        for (Map.Entry entry : asProperty.get("ModelWithTuple2").getProperties().entrySet()) {
            Property items;
            String name = (String)entry.getKey();
            Property property = (Property)entry.getValue();
            if ("timesheetStates".equals(name)) {
                Assert.assertEquals(property.getClass(), MapProperty.class);
                continue;
            }
            if ("manyPairs".equals(name)) {
                Assert.assertEquals(property.getClass(), ArrayProperty.class);
                items = ((ArrayProperty)property).getItems();
                Assert.assertNotNull((Object)items);
                Assert.assertEquals(items.getClass(), MapProperty.class);
                Property stringProperty = ((MapProperty)items).getAdditionalProperties();
                Assert.assertNotNull((Object)stringProperty);
                Assert.assertEquals(stringProperty.getClass(), StringProperty.class);
                continue;
            }
            if ("complexLeft".equals(name)) {
                Assert.assertEquals(property.getClass(), ArrayProperty.class);
                items = ((ArrayProperty)property).getItems();
                Assert.assertNotNull((Object)items);
                Assert.assertEquals(items.getClass(), MapProperty.class);
                Property additionalProperty = ((MapProperty)items).getAdditionalProperties();
                Assert.assertNotNull((Object)additionalProperty);
                Assert.assertEquals(additionalProperty.getClass(), RefProperty.class);
                Assert.assertEquals((String)((RefProperty)additionalProperty).getSimpleRef(), (String)"ComplexLeft");
                continue;
            }
            Assert.fail((String)String.format("Unexpected property: %s", name));
        }
    }

    @Test(description="it should scan an empty model per 499")
    public void scanEmptyModel() {
        Map<String, Model> schemas = this.readAll((Type)((Object)EmptyModel.class));
        ModelImpl model = (ModelImpl)schemas.get("EmptyModel");
        Assert.assertNull((Object)model.getProperties());
        Assert.assertEquals((String)model.getType(), (String)"object");
    }

    @Test(description="it should override the property name")
    public void overridePropertyName() {
        Map<String, Model> schemas = this.readAll((Type)((Object)ModelWithAltPropertyName.class));
        Map properties = schemas.get("sample_model").getProperties();
        Assert.assertNull(properties.get("id"));
        Assert.assertNotNull(properties.get("the_id"));
    }

    @Test(description="it should convert a model with enum array")
    public void convertModelWithEnumArray() {
        Map<String, Model> schemas = this.readAll((Type)((Object)ModelWithEnumArray.class));
        Assert.assertEquals((int)schemas.size(), (int)1);
    }

    private Type getGenericType(Class<?> cls) throws Exception {
        return this.getClass().getDeclaredMethod("getGenericType", Class.class).getGenericParameterTypes()[0];
    }

    @Test(description="it should check handling of the Class<?> type")
    public void checkHandlingClassType() throws Exception {
        Type type = this.getGenericType(null);
        Assert.assertFalse((boolean)(type instanceof Class));
        Map<String, Model> schemas = this.readAll(type);
        Assert.assertEquals((int)schemas.size(), (int)0);
    }

    @Test(description="it should convert a model with Formatted strings")
    public void convertModelWithFormattedStrings() throws IOException {
        Model model = this.readAll((Type)((Object)ModelWithFormattedStrings.class)).get("ModelWithFormattedStrings");
        this.assertEqualsToJson(model, "ModelWithFormattedStrings.json");
    }

    @Test(description="it should check handling of string types")
    public void checkStringTypesHandling() {
        for (Class cls : Arrays.asList(URI.class, URL.class, UUID.class)) {
            Map<String, Model> schemas = this.readAll(cls);
            Assert.assertEquals((int)schemas.size(), (int)0);
            Property property = ModelConverters.getInstance().readAsProperty((Type)cls);
            Assert.assertNotNull((Object)property);
            Assert.assertEquals((String)property.getType(), (String)"string");
        }
    }

    @Test(description="it should scan a model per #1155")
    public void scanModel() {
        Map<String, Model> model = this.read((Type)((Object)Model1155.class));
        Assert.assertEquals(model.get("Model1155").getProperties().keySet(), (Set)ImmutableSet.of((Object)"valid", (Object)"value", (Object)"is", (Object)"get", (Object)"isA", (Object)"getA", (Object[])new String[]{"is_persistent", "gettersAndHaters"}));
    }

    @Test(description="it should scan a model with numbers")
    public void scanModelWithNumbers() throws IOException {
        Map<String, Model> models = this.readAll((Type)((Object)ModelWithNumbers.class));
        Assert.assertEquals((int)models.size(), (int)1);
        Model model = models.get("ModelWithNumbers");
        this.checkModel(model);
        this.checkModel((Model)Json.mapper().readValue(Json.pretty((Object)model), Model.class));
    }

    private void checkType(Property property, Class<?> cls, String type, String format) {
        Assert.assertTrue((boolean)cls.isInstance(property));
        Assert.assertEquals((String)property.getType(), (String)type);
        Assert.assertEquals((String)property.getFormat(), (String)format);
    }

    private void checkModel(Model model) {
        for (Map.Entry entry : model.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            Property property = (Property)entry.getValue();
            if (Arrays.asList("shortPrimitive", "shortObject", "intPrimitive", "intObject").contains(name)) {
                this.checkType(property, IntegerProperty.class, "integer", "int32");
                continue;
            }
            if (Arrays.asList("longPrimitive", "longObject").contains(name)) {
                this.checkType(property, LongProperty.class, "integer", "int64");
                continue;
            }
            if (Arrays.asList("floatPrimitive", "floatObject").contains(name)) {
                this.checkType(property, FloatProperty.class, "number", "float");
                continue;
            }
            if (Arrays.asList("doublePrimitive", "doubleObject").contains(name)) {
                this.checkType(property, DoubleProperty.class, "number", "double");
                continue;
            }
            if ("bigInteger".equals(name)) {
                this.checkType(property, BaseIntegerProperty.class, "integer", null);
                continue;
            }
            if ("bigDecimal".equals(name)) {
                this.checkType(property, DecimalProperty.class, "number", null);
                continue;
            }
            Assert.fail((String)String.format("Unexpected property: %s", name));
        }
    }

    @Test
    public void formatDate() {
        Map models = ModelConverters.getInstance().read(DateModel.class);
        Model model = (Model)models.get("DateModel");
        Assert.assertEquals((int)model.getProperties().size(), (int)5);
        String json = "{   \"type\":\"object\",   \"properties\":{      \"date\":{         \"type\":\"string\",         \"format\":\"date-time\",         \"position\":1      },      \"intValue\":{         \"type\":\"integer\",         \"format\":\"int32\",         \"position\":2      },      \"longValue\":{         \"type\":\"integer\",         \"format\":\"int64\",         \"position\":3      },      \"floatValue\":{         \"type\":\"number\",         \"format\":\"float\",         \"position\":4      },      \"doubleValue\":{         \"type\":\"number\",         \"format\":\"double\",         \"position\":5      }   }}";
        SerializationMatchers.assertEqualsToJson(model, "{   \"type\":\"object\",   \"properties\":{      \"date\":{         \"type\":\"string\",         \"format\":\"date-time\",         \"position\":1      },      \"intValue\":{         \"type\":\"integer\",         \"format\":\"int32\",         \"position\":2      },      \"longValue\":{         \"type\":\"integer\",         \"format\":\"int64\",         \"position\":3      },      \"floatValue\":{         \"type\":\"number\",         \"format\":\"float\",         \"position\":4      },      \"doubleValue\":{         \"type\":\"number\",         \"format\":\"double\",         \"position\":5      }   }}");
    }

    class DateModel {
        @ApiModelProperty(position=1)
        public Date date;
        @ApiModelProperty(position=2)
        public int intValue;
        @ApiModelProperty(position=3)
        public Long longValue;
        @ApiModelProperty(position=4)
        public Float floatValue;
        @ApiModelProperty(position=5)
        public Double doubleValue;

        DateModel() {
        }
    }
}

