/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiParam;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Size;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParameterProcessorTest {
    private void parametrizedMethod(@ApiParam(name="paramName1", value="paramValue1", defaultValue="value1", required=true, allowableValues="one, two, three, ") @PathParam(value="param1") String arg1, @ApiParam(name="paramName2", access="test") @DefaultValue(value="10") @QueryParam(value="param2") List<Integer> arg2, @Context String arg3, @ApiParam(name="paramName4", hidden=true) @QueryParam(value="hiddenParam") String arg4, @ApiParam(name="paramName4") Integer arg5) {
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="paramName1", value="paramValue1", dataType="string", paramType="path", allowMultiple=true, allowableValues=",,,"), @ApiImplicitParam(value="paramValue2", dataType="string", paramType="body", access="test", defaultValue="10")})
    private void implicitParametrizedMethod() {
    }

    private void rangedParametrizedMethod(@ApiParam(value="sample param data", defaultValue="5", allowableValues="range[0,10]") @PathParam(value="id") Integer id, @ApiParam(value="sample positive infinity data", allowableValues="range(0, infinity)") @PathParam(value="minValue") Double minValue, @ApiParam(value="sample negative infinity data", allowableValues="range[-infinity, 100]") @PathParam(value="maxValue") Integer maxValue, @ApiParam(value="sample array data", allowMultiple=true, allowableValues="range(0, 5)") @PathParam(value="values") Integer values) {
    }

    private void arrayParametrizedMethod(@HeaderParam(value="ids") @Size(min=5, max=10) List<Long> ids) {
    }

    @Test(description="parse parameters from method")
    public void parameterProcessorTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("parametrizedMethod", String.class, List.class, String.class, String.class, Integer.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        PathParameter p1 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((String)p1.getIn(), (String)"path");
        Assert.assertEquals((String)p1.getName(), (String)"paramName1");
        Assert.assertEquals((String)p1.getDescription(), (String)"paramValue1");
        Assert.assertEquals((String)p1.getDefaultValue(), (String)"value1");
        Assert.assertTrue((boolean)p1.getRequired());
        Assert.assertEquals((Collection)p1.getEnum(), Arrays.asList("one", "two", "three"));
        Assert.assertNull((Object)p1.getAccess());
        QueryParameter p2 = (QueryParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new QueryParameter().items((Property)new IntegerProperty()), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)p2);
        IntegerProperty items = (IntegerProperty)p2.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((String)p2.getIn(), (String)"query");
        Assert.assertEquals((String)p2.getName(), (String)"paramName2");
        Assert.assertNull((Object)p2.getDescription());
        Assert.assertEquals((int)items.getDefault(), (int)10);
        Assert.assertFalse((boolean)p2.getRequired());
        Assert.assertEquals((String)p2.getAccess(), (String)"test");
        Parameter p3 = ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[2], Arrays.asList(paramAnnotations[2]));
        Assert.assertNull((Object)p3);
        Parameter p4 = ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[3], Arrays.asList(paramAnnotations[3]));
        Assert.assertNull((Object)p4);
        BodyParameter p5 = (BodyParameter)ParameterProcessor.applyAnnotations(null, null, (Type)genericParameterTypes[4], Arrays.asList(paramAnnotations[4]));
        Assert.assertNotNull((Object)p5);
        Assert.assertEquals((String)p5.getIn(), (String)"body");
    }

    @Test(description="parse implicit parameters from method")
    public void implicitParameterProcessorTest() throws NoSuchMethodException {
        ApiImplicitParams params = this.getClass().getDeclaredMethod("implicitParametrizedMethod", new Class[0]).getAnnotation(ApiImplicitParams.class);
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), String.class, Collections.singletonList(params.value()[0]));
        Assert.assertNotNull((Object)param0);
        Assert.assertEquals((String)param0.getIn(), (String)"path");
        Assert.assertEquals((String)param0.getName(), (String)"paramName1");
        Assert.assertEquals((String)param0.getDescription(), (String)"paramValue1");
        Assert.assertNull((Object)param0.getEnum());
        Assert.assertNotNull((Object)param0.getItems());
        BodyParameter param1 = (BodyParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new BodyParameter(), String.class, Collections.singletonList(params.value()[1]));
        Assert.assertNotNull((Object)param1);
        Assert.assertEquals((String)param1.getIn(), (String)"body");
        Assert.assertEquals((String)param1.getName(), (String)"body");
        Assert.assertEquals((String)param1.getDescription(), (String)"paramValue2");
        Assert.assertEquals((String)param1.getAccess(), (String)"test");
        ModelImpl model = (ModelImpl)param1.getSchema();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((String)model.getDefaultValue(), (String)"10");
    }

    @Test
    public void resourceWithParamRangeTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("rangedParametrizedMethod", Integer.class, Double.class, Integer.class, Integer.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        PathParameter param0 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param0);
        Assert.assertEquals((String)param0.getDefaultValue(), (String)"5");
        Assert.assertEquals((Object)param0.getMinimum(), (Object)0.0);
        Assert.assertEquals((Object)param0.getMaximum(), (Object)10.0);
        PathParameter param1 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[1], Arrays.asList(paramAnnotations[1]));
        Assert.assertNotNull((Object)param1);
        Assert.assertEquals((Object)param1.getMinimum(), (Object)0.0);
        Assert.assertNull((Object)param1.getMaximum(), null);
        Assert.assertTrue((boolean)param1.isExclusiveMinimum());
        Assert.assertTrue((boolean)param1.isExclusiveMaximum());
        PathParameter param2 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter(), (Type)genericParameterTypes[2], Arrays.asList(paramAnnotations[2]));
        Assert.assertNotNull((Object)param2);
        Assert.assertNull((Object)param2.getMinimum());
        Assert.assertEquals((Object)param2.getMaximum(), (Object)100.0);
        PathParameter param3 = (PathParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new PathParameter().items((Property)new IntegerProperty()), (Type)genericParameterTypes[3], Arrays.asList(paramAnnotations[3]));
        Assert.assertNotNull((Object)param3);
        IntegerProperty items = (IntegerProperty)param3.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((Object)items.getMinimum(), (Object)0.0);
        Assert.assertEquals((Object)items.getMaximum(), (Object)5.0);
        Assert.assertTrue((boolean)items.getExclusiveMinimum());
        Assert.assertTrue((boolean)items.getExclusiveMaximum());
    }

    @Test
    public void resourceWithArrayParamTest() throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod("arrayParametrizedMethod", List.class);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        HeaderParameter param = (HeaderParameter)ParameterProcessor.applyAnnotations(null, (Parameter)new HeaderParameter(), (Type)genericParameterTypes[0], Arrays.asList(paramAnnotations[0]));
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((int)param.getMinItems(), (int)5);
        Assert.assertEquals((int)param.getMaxItems(), (int)10);
    }
}

