/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleGenerationTest
extends SwaggerTestBase {
    private final ModelResolver modelResolver = new ModelResolver(new ObjectMapper());
    private final ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)this.modelResolver);

    @Test
    public void testSimple() throws Exception {
        Model model = this.context.resolve(SimpleBean.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((String)model.getDescription(), (String)"DESC");
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)6);
        for (Map.Entry entry : props.entrySet()) {
            String name = (String)entry.getKey();
            Property prop = (Property)entry.getValue();
            if ("a".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                continue;
            }
            if ("b".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"integer");
                Assert.assertEquals((String)prop.getFormat(), (String)"int32");
                continue;
            }
            if ("c".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"integer");
                Assert.assertEquals((String)prop.getFormat(), (String)"int64");
                continue;
            }
            if ("d".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"number");
                Assert.assertEquals((String)prop.getFormat(), (String)"float");
                continue;
            }
            if ("e".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"number");
                Assert.assertEquals((String)prop.getFormat(), (String)"double");
                continue;
            }
            if ("f".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                Assert.assertEquals((String)prop.getFormat(), (String)"date-time");
                continue;
            }
            Assert.fail((String)String.format("Unknown property '%s'", name));
        }
    }

    @Test
    public void testOrdering() throws Exception {
        Model jsonOrderBean = this.context.resolve(JsonOrderBean.class);
        Map props = jsonOrderBean.getProperties();
        Assert.assertEquals(new ArrayList(props.keySet()), Arrays.asList("a", "b", "c", "d"));
        Model positionBean = this.context.resolve(PositionBean.class);
        Map positionBeanProps = positionBean.getProperties();
        Assert.assertEquals((int)positionBeanProps.size(), (int)4);
        Property prop = (Property)positionBeanProps.get("c");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((int)prop.getPosition(), (int)3);
    }

    @Test
    public void testTheCountBean() throws Exception {
        Model model = this.context.resolve(TheCount.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)1);
        Property prop = (Property)props.values().iterator().next();
        Assert.assertEquals((String)prop.getName(), (String)"theCount");
    }

    @Test
    public void testStringDateMap() throws Exception {
        Model model = this.context.resolve(StringDateMapBean.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)1);
        Property prop = (Property)props.values().iterator().next();
        Assert.assertEquals((String)prop.getName(), (String)"stuff");
    }

    @Test
    public void testIntArray() throws Exception {
        Model model = this.context.resolve(IntArrayBean.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)1);
        Property prop = (Property)props.values().iterator().next();
        Assert.assertEquals((String)prop.getName(), (String)"b");
        Assert.assertEquals((String)prop.getType(), (String)"array");
    }

    @JsonPropertyOrder(value={"a", "b"})
    static class IntArrayBean {
        public int[] b;

        IntArrayBean() {
        }
    }

    static class StringDateMapBean {
        public Map<String, Date> stuff;

        StringDateMapBean() {
        }
    }

    static class TheCount {
        @JsonProperty(value="theCount")
        private Integer count;

        TheCount() {
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }

    static class PositionBean {
        @ApiModelProperty(position=4)
        public int d;
        @ApiModelProperty(position=1)
        public int a;
        @ApiModelProperty(position=3)
        public int c;
        @ApiModelProperty(position=2)
        public int b;

        PositionBean() {
        }
    }

    @JsonPropertyOrder(value={"a", "b", "c", "d"})
    static class JsonOrderBean {
        public int d;
        public int a;
        public int c;
        public int b;

        JsonOrderBean() {
        }
    }

    @JsonPropertyOrder(value={"a", "b"})
    @ApiModel(description="DESC")
    static class SimpleBean {
        public int b;
        public long c;
        public float d;
        public double e;
        public Date f;

        SimpleBean() {
        }

        public String getA() {
            return null;
        }
    }
}

