/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.TestUtils;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonDeserializationTest {
    @Test
    public void testDeserializePetStoreFile() throws Exception {
        TestUtils.deserializeJsonFileFromClasspath("specFiles/petstore.json", Swagger.class);
    }

    @Test
    public void testDeserializeCompositionTest() throws Exception {
        TestUtils.deserializeJsonFileFromClasspath("specFiles/compositionTest.json", Swagger.class);
    }

    @Test
    public void testDeserializeAPathRef() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/pathRef.json", Swagger.class);
        Path petPath = swagger.getPath("/pet");
        Assert.assertTrue((boolean)(petPath instanceof RefPath));
        Assert.assertEquals((String)((RefPath)petPath).get$ref(), (String)"http://my.company.com/paths/health.json");
        Assert.assertTrue((boolean)(swagger.getPath("/user") instanceof Path));
    }

    @Test
    public void testDeserializeAResponseRef() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/responseRef.json", Swagger.class);
        Map responseMap = swagger.getPath("/pet").getPut().getResponses();
        this.assertIsRefResponse((Response)responseMap.get("405"), "http://my.company.com/responses/errors.json#/method-not-allowed");
        this.assertIsRefResponse((Response)responseMap.get("404"), "http://my.company.com/responses/errors.json#/not-found");
        Assert.assertTrue((boolean)(responseMap.get("400") instanceof Response));
    }

    private void assertIsRefResponse(Response response, String expectedRef) {
        Assert.assertTrue((boolean)(response instanceof RefResponse));
        RefResponse refResponse = (RefResponse)response;
        Assert.assertEquals((String)refResponse.get$ref(), (String)expectedRef);
    }

    @Test
    public void testDeserializeSecurity() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/securityDefinitions.json", Swagger.class);
        List security = swagger.getSecurity();
        List securityRequirements = swagger.getSecurityRequirement();
        Assert.assertNotNull((Object)security);
        Assert.assertEquals((Collection)security, (Collection)securityRequirements);
        Assert.assertEquals((int)security.size(), (int)2);
        SecurityRequirement securityRequirement = (SecurityRequirement)security.get(0);
        Map requirements = securityRequirement.getRequirements();
        List basic_auth = (List)requirements.get("basic_auth");
        Assert.assertNotNull((Object)basic_auth);
        Assert.assertTrue((boolean)basic_auth.isEmpty());
        List api_key = (List)requirements.get("api_key");
        Assert.assertNotNull((Object)api_key);
        Assert.assertTrue((boolean)api_key.isEmpty());
        securityRequirement = (SecurityRequirement)security.get(1);
        requirements = securityRequirement.getRequirements();
        List oauth2 = (List)requirements.get("oauth2");
        Assert.assertNotNull((Object)oauth2);
        Assert.assertFalse((boolean)oauth2.isEmpty());
        Assert.assertEquals((String)((String)oauth2.get(0)), (String)"hello");
        Assert.assertEquals((String)((String)oauth2.get(1)), (String)"world");
    }

    @Test(description="should deserialize a property with vendor extensions of different types")
    public void testDeserializePropertyWithVendorExtensions() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/propertyWithVendorExtensions.json", Swagger.class);
        Map vendorExtensions = ((Property)((Model)swagger.getDefinitions().get("Health")).getProperties().get("status")).getVendorExtensions();
        Assert.assertNotNull((Object)vendorExtensions);
        Assert.assertEquals((int)6, (int)vendorExtensions.size());
        String xStringValue = (String)vendorExtensions.get("x-string-value");
        Assert.assertNotNull((Object)xStringValue);
        Assert.assertEquals((String)xStringValue, (String)"Hello World");
        Assert.assertTrue((boolean)vendorExtensions.containsKey("x-null-value"));
        Assert.assertNull(vendorExtensions.get("x-null-value"));
        Map xMapValue = (Map)vendorExtensions.get("x-map-value");
        Assert.assertNotNull((Object)xMapValue);
        Assert.assertEquals((String)((String)xMapValue.get("hello")), (String)"world");
        Assert.assertEquals((String)((String)xMapValue.get("foo")), (String)"bar");
        List xListValue = (List)vendorExtensions.get("x-list-value");
        Assert.assertNotNull((Object)xListValue);
        Assert.assertEquals((String)((String)xListValue.get(0)), (String)"Hello");
        Assert.assertEquals((String)((String)xListValue.get(1)), (String)"World");
        Integer xNumberValue = (Integer)vendorExtensions.get("x-number-value");
        Assert.assertNotNull((Object)xNumberValue);
        Assert.assertEquals((int)xNumberValue, (int)123);
        Boolean xBooleanValue = (Boolean)vendorExtensions.get("x-boolean-value");
        Assert.assertNotNull((Object)xBooleanValue);
        Assert.assertTrue((boolean)xBooleanValue);
        Assert.assertFalse((boolean)vendorExtensions.containsKey("not-an-extension"));
        vendorExtensions = ((Property)((Model)swagger.getDefinitions().get("Health")).getProperties().get("array")).getVendorExtensions();
        xStringValue = (String)vendorExtensions.get("x-string-value");
        Assert.assertNotNull((Object)xStringValue);
        Assert.assertEquals((String)xStringValue, (String)"string_value");
    }
}

