/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonSerializationTest {
    @Test
    public void testSerializeASpecWithPathReferences() throws Exception {
        Swagger swagger = new Swagger().host("petstore.swagger.io").consumes("application/json").produces("application/json");
        RefPath expectedPath = new RefPath("http://my.company.com/paths/health.json");
        swagger.path("/health", (Path)expectedPath);
        String swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Swagger rebuilt = (Swagger)Json.mapper().readValue(swaggerJson, Swagger.class);
        Path path = rebuilt.getPath("/health");
        RefPath actualPath = (RefPath)path;
        Assert.assertEquals((Object)actualPath, (Object)expectedPath);
    }

    @Test
    public void testSerializeASpecWithResponseReferences() throws Exception {
        Swagger swagger = new Swagger().host("petstore.swagger.io").consumes("application/json").produces("application/json");
        RefResponse expectedResponse = new RefResponse("http://my.company.com/paths/health.json");
        swagger.path("/health", new Path().get(new Operation().response(200, (Response)expectedResponse)));
        String swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Swagger rebuilt = (Swagger)Json.mapper().readValue(swaggerJson, Swagger.class);
        Assert.assertEquals(rebuilt.getPath("/health").getGet().getResponses().get("200"), (Object)expectedResponse);
    }

    @Test
    public void testSerializeSecurityRequirement_UsingSpecCompliantMethods() throws Exception {
        SecurityRequirement securityRequirement = new SecurityRequirement().requirement("oauth2", Arrays.asList("hello", "world"));
        String json = Json.mapper().writeValueAsString((Object)securityRequirement);
        Assert.assertEquals((String)json, (String)"{\"oauth2\":[\"hello\",\"world\"]}");
        securityRequirement = new SecurityRequirement().requirement("api_key");
        json = Json.mapper().writeValueAsString((Object)securityRequirement);
        Assert.assertEquals((String)json, (String)"{\"api_key\":[]}");
        Swagger swagger = new Swagger().security(new SecurityRequirement().requirement("api_key").requirement("basic_auth")).security(new SecurityRequirement().requirement("oauth2", Arrays.asList("hello", "world")));
        json = Json.mapper().writeValueAsString((Object)swagger);
        Assert.assertEquals((String)json, (String)"{\"swagger\":\"2.0\",\"security\":[{\"basic_auth\":[],\"api_key\":[]},{\"oauth2\":[\"hello\",\"world\"]}]}");
    }
}

