/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import com.google.inject.Module;
import io.takari.maven.testing.MavenRuntime;
import io.takari.maven.testing.TestProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;

class Maven30xRuntime
implements MavenRuntime {
    private static final String PATH_PLUGINXML = "META-INF/maven/plugin.xml";
    protected final TestProperties properties = new TestProperties();
    protected final DefaultPlexusContainer container;
    protected final Map<String, MojoDescriptor> mojoDescriptors;

    public Maven30xRuntime(Module[] modules) throws Exception {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        this.container = new DefaultPlexusContainer(cc, modules);
        this.mojoDescriptors = Collections.unmodifiableMap(this.readPluginXml(this.container));
    }

    private Map<String, MojoDescriptor> readPluginXml(DefaultPlexusContainer container) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            return Collections.emptyMap();
        }
        XmlStreamReader reader = new XmlStreamReader(is);
        Map contextData = container.getContext().getContextData();
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)new BufferedReader((Reader)reader), contextData);
        PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationFilterReader);
        Artifact artifact = ((RepositorySystem)container.lookup(RepositorySystem.class)).createArtifact(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion(), ".jar");
        artifact.setFile(this.getPluginArtifactFile());
        pluginDescriptor.setPluginArtifact(artifact);
        pluginDescriptor.setArtifacts(Arrays.asList(artifact));
        for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
            container.addComponentDescriptor(desc);
        }
        HashMap<String, MojoDescriptor> mojoDescriptors = new HashMap<String, MojoDescriptor>();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            mojoDescriptors.put(mojoDescriptor.getGoal(), mojoDescriptor);
        }
        return mojoDescriptors;
    }

    private File getPluginArtifactFile() throws IOException {
        URL resource = this.getClass().getResource("/META-INF/maven/plugin.xml");
        File file = null;
        if (resource != null) {
            if ("file".equalsIgnoreCase(resource.getProtocol())) {
                String path = resource.getPath();
                if (path.endsWith(PATH_PLUGINXML)) {
                    file = new File(path.substring(0, path.length() - PATH_PLUGINXML.length()));
                }
            } else if ("jar".equalsIgnoreCase(resource.getProtocol())) {
                try {
                    String path;
                    URL jarfile = new URL(resource.getPath());
                    if ("file".equalsIgnoreCase(jarfile.getProtocol()) && (path = jarfile.getPath()).endsWith(PATH_PLUGINXML)) {
                        file = new File(path.substring(0, path.length() - PATH_PLUGINXML.length() - 2));
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (file == null || !file.exists()) {
            file = new File("").getCanonicalFile();
        }
        return file.getCanonicalFile();
    }

    @Override
    public void shutdown() {
        this.container.dispose();
    }

    @Override
    public MavenProject readMavenProject(File basedir) throws Exception {
        File pom = new File(basedir, "pom.xml");
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setBaseDirectory(basedir);
        ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
        return ((ProjectBuilder)this.container.lookup(ProjectBuilder.class)).build(pom, configuration).getProject();
    }

    @Override
    public MojoExecution newMojoExecution(String goal) {
        MojoDescriptor mojoDescriptor = this.mojoDescriptors.get(goal);
        Assert.assertNotNull((String)String.format("The MojoDescriptor for the goal %s cannot be null.", goal), (Object)mojoDescriptor);
        MojoExecution execution = new MojoExecution(mojoDescriptor);
        this.finalizeMojoConfiguration(execution);
        return execution;
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Xpp3Dom executionConfiguration = mojoExecution.getConfiguration();
        if (executionConfiguration == null) {
            executionConfiguration = new Xpp3Dom("configuration");
        }
        Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((String)(parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("implementation")) && StringUtils.isNotEmpty((String)parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        mojoExecution.setConfiguration(finalConfiguration);
    }

    @Override
    public MavenSession newMavenSession() throws Exception {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        request.setLocalRepositoryPath(this.properties.getLocalRepository());
        request.setUserSettingsFile(this.properties.getUserSettings());
        request.setOffline(this.properties.getOffline());
        request.setUpdateSnapshots(this.properties.getUpdateSnapshots());
        request = ((MavenExecutionRequestPopulator)this.container.lookup(MavenExecutionRequestPopulator.class)).populateDefaults((MavenExecutionRequest)request);
        DefaultMaven maven = (DefaultMaven)this.container.lookup(Maven.class);
        try {
            Object repositorySession = maven.getClass().getMethod("newRepositorySession", MavenExecutionRequest.class).invoke((Object)maven, request);
            Class<?> repositorySessionClass = repositorySession.getClass().getClassLoader().loadClass("org.sonatype.aether.RepositorySystemSession");
            Constructor constructor = MavenSession.class.getConstructor(PlexusContainer.class, repositorySessionClass, MavenExecutionRequest.class, MavenExecutionResult.class);
            return (MavenSession)constructor.newInstance(this.container, repositorySession, request, result);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        this.lookupConfiguredMojo(session, execution).execute();
    }

    @Override
    public Mojo lookupConfiguredMojo(MavenSession session, MojoExecution execution) throws Exception {
        MavenProject project = session.getCurrentProject();
        MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
        Mojo mojo = (Mojo)this.container.lookup(Mojo.class, mojoDescriptor.getRoleHint());
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(session, execution);
        Xpp3Dom configuration = null;
        Plugin plugin = project.getPlugin(mojoDescriptor.getPluginDescriptor().getPluginLookupKey());
        if (plugin != null) {
            configuration = (Xpp3Dom)plugin.getConfiguration();
        }
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
        }
        configuration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)execution.getConfiguration());
        XmlPlexusConfiguration pluginConfiguration = new XmlPlexusConfiguration(configuration);
        String configuratorHint = "basic";
        if (mojoDescriptor.getComponentConfigurator() != null) {
            configuratorHint = mojoDescriptor.getComponentConfigurator();
        }
        ComponentConfigurator configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, configuratorHint);
        configurator.configureComponent((Object)mojo, (PlexusConfiguration)pluginConfiguration, (ExpressionEvaluator)evaluator, this.container.getContainerRealm());
        return mojo;
    }

    @Override
    public DefaultPlexusContainer getContainer() {
        return this.container;
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return (T)this.container.lookup(role);
    }
}

