/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import com.google.inject.Module;
import io.takari.maven.testing.Maven311Runtime;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

class Maven321Runtime
extends Maven311Runtime {
    public Maven321Runtime(Module[] modules) throws Exception {
        super(modules);
    }

    @Override
    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        Object sessionScope = this.container.lookup("org.apache.maven.SessionScope");
        try {
            Maven321Runtime.enter(sessionScope);
            Maven321Runtime.seed(sessionScope, MavenSession.class, session);
            MojoExecutionScope executionScope = (MojoExecutionScope)this.container.lookup(MojoExecutionScope.class);
            try {
                executionScope.enter();
                executionScope.seed(MavenProject.class, (Object)project);
                executionScope.seed(MojoExecution.class, (Object)execution);
                Mojo mojo = this.lookupConfiguredMojo(session, execution);
                mojo.execute();
                MojoExecutionEvent event = new MojoExecutionEvent(session, project, execution, mojo);
                for (MojoExecutionListener listener : this.container.lookupList(MojoExecutionListener.class)) {
                    listener.afterMojoExecutionSuccess(event);
                }
            }
            finally {
                executionScope.exit();
            }
        }
        finally {
            Maven321Runtime.exit(sessionScope);
        }
    }

    private static void enter(Object scope) throws Exception {
        scope.getClass().getMethod("enter", new Class[0]).invoke(scope, new Object[0]);
    }

    private static void seed(Object scope, Class type, Object instance) throws Exception {
        scope.getClass().getMethod("seed", Class.class, Object.class).invoke(scope, type, instance);
    }

    private static void exit(Object scope) throws Exception {
        scope.getClass().getMethod("exit", new Class[0]).invoke(scope, new Object[0]);
    }
}

