/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import com.google.inject.Module;
import io.takari.maven.testing.Maven30xRuntime;
import io.takari.maven.testing.Maven311Runtime;
import io.takari.maven.testing.Maven321Runtime;
import io.takari.maven.testing.Maven325Runtime;
import io.takari.maven.testing.MavenRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestMavenRuntime
implements TestRule {
    private static final DefaultArtifactVersion MAVEN_VERSION;
    private static final DefaultArtifactVersion MINIMAL_VERSION;
    private static final Map<DefaultArtifactVersion, RuntimeFactory> FACTORIES;
    private final Module[] modules;
    private MavenRuntime runtime;

    static {
        DefaultArtifactVersion version = null;
        String path = "/META-INF/maven/org.apache.maven/maven-core/pom.properties";
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = TestMavenRuntime.class.getResourceAsStream(path);){
                String property;
                Properties properties = new Properties();
                if (is != null) {
                    properties.load(is);
                }
                if ((property = properties.getProperty("version")) != null) {
                    version = new DefaultArtifactVersion(property);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        MAVEN_VERSION = version;
        MINIMAL_VERSION = new DefaultArtifactVersion("3.0");
        LinkedHashMap<DefaultArtifactVersion, RuntimeFactory> factories = new LinkedHashMap<DefaultArtifactVersion, RuntimeFactory>();
        factories.put(new DefaultArtifactVersion("3.1.1"), new RuntimeFactory(){

            @Override
            public MavenRuntime newInstance(Module[] modules) throws Exception {
                return new Maven30xRuntime(modules);
            }
        });
        factories.put(new DefaultArtifactVersion("3.2.1"), new RuntimeFactory(){

            @Override
            public MavenRuntime newInstance(Module[] modules) throws Exception {
                return new Maven311Runtime(modules);
            }
        });
        factories.put(new DefaultArtifactVersion("3.2.5"), new RuntimeFactory(){

            @Override
            public MavenRuntime newInstance(Module[] modules) throws Exception {
                return new Maven321Runtime(modules);
            }
        });
        factories.put(null, new RuntimeFactory(){

            @Override
            public MavenRuntime newInstance(Module[] modules) throws Exception {
                return new Maven325Runtime(modules);
            }
        });
        FACTORIES = Collections.unmodifiableMap(factories);
    }

    public TestMavenRuntime() {
        this(new Module[0]);
    }

    public TestMavenRuntime(Module ... modules) {
        this.modules = modules;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestMavenRuntime.this.runtime = TestMavenRuntime.this.newMavenRuntime(TestMavenRuntime.this.modules);
                try {
                    base.evaluate();
                }
                finally {
                    TestMavenRuntime.this.runtime.shutdown();
                    TestMavenRuntime.this.runtime = null;
                }
            }
        };
    }

    private MavenRuntime newMavenRuntime(Module[] modules) throws Exception {
        if (MAVEN_VERSION.compareTo((ArtifactVersion)MINIMAL_VERSION) < 0) {
            throw new AssertionError((Object)String.format("Maven version %s is not supported, please use %s or newer", MAVEN_VERSION, MINIMAL_VERSION));
        }
        ArrayList<Map.Entry<DefaultArtifactVersion, RuntimeFactory>> versions = new ArrayList<Map.Entry<DefaultArtifactVersion, RuntimeFactory>>(FACTORIES.entrySet());
        int i = 0;
        while (i < versions.size() - 1) {
            Map.Entry entry = (Map.Entry)versions.get(i);
            if (MAVEN_VERSION.compareTo((ArtifactVersion)entry.getKey()) < 0) {
                return ((RuntimeFactory)entry.getValue()).newInstance(modules);
            }
            ++i;
        }
        return ((RuntimeFactory)((Map.Entry)versions.get(versions.size() - 1)).getValue()).newInstance(modules);
    }

    public MavenProject readMavenProject(File basedir) throws Exception {
        MavenProject project = this.runtime.readMavenProject(basedir);
        Assert.assertNotNull((Object)project);
        return project;
    }

    public MavenSession newMavenSession(MavenProject project) throws Exception {
        MavenSession session = this.runtime.newMavenSession();
        session.setCurrentProject(project);
        session.setProjects(Arrays.asList(project));
        return session;
    }

    public MojoExecution newMojoExecution(String goal) {
        return this.runtime.newMojoExecution(goal);
    }

    public void executeMojo(File basedir, String goal, Xpp3Dom ... parameters) throws Exception {
        MavenProject project = this.readMavenProject(basedir);
        MavenSession session = this.newMavenSession(project);
        this.executeMojo(session, project, goal, parameters);
    }

    public void executeMojo(MavenSession session, MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MojoExecution execution = this.newMojoExecution(goal);
        if (parameters != null) {
            Xpp3Dom configuration = execution.getConfiguration();
            Xpp3Dom[] xpp3DomArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom parameter = xpp3DomArray[n2];
                configuration.addChild(parameter);
                ++n2;
            }
        }
        this.executeMojo(session, project, execution);
    }

    public void executeMojo(MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MavenSession session = this.newMavenSession(project);
        this.executeMojo(session, project, goal, parameters);
    }

    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        this.runtime.executeMojo(session, project, execution);
    }

    public Mojo lookupConfiguredMojo(MavenSession session, MojoExecution execution) throws Exception {
        return this.runtime.lookupConfiguredMojo(session, execution);
    }

    public DefaultPlexusContainer getContainer() {
        return this.runtime.getContainer();
    }

    public <T> T lookup(Class<T> role) throws Exception {
        return this.runtime.lookup(role);
    }

    public static Xpp3Dom newParameter(String name, String value) {
        Xpp3Dom child = new Xpp3Dom(name);
        child.setValue(value);
        return child;
    }

    private static interface RuntimeFactory {
        public MavenRuntime newInstance(Module[] var1) throws Exception;
    }
}

