/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import io.takari.maven.testing.executor.LauncherException;
import io.takari.maven.testing.executor.MavenLauncher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.codehaus.plexus.util.Os;

class ForkedLauncher
implements MavenLauncher {
    private final File mavenHome;
    private final File classworldsJar;
    private final Map<String, String> envVars;
    private final List<String> extensions;
    private final List<String> args;

    public ForkedLauncher(File mavenHome, File classworldsConf, List<String> extensions, Map<String, String> envVars, List<String> args) {
        this.args = args;
        if (mavenHome == null) {
            throw new NullPointerException();
        }
        if (classworldsConf != null) {
            throw new IllegalArgumentException("Custom classworlds configuration file is not supported");
        }
        this.mavenHome = mavenHome;
        this.envVars = envVars;
        this.extensions = extensions;
        File classworldsJar = null;
        File[] files = new File(mavenHome, "boot").listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (name.startsWith("plexus-classworlds-") && name.endsWith(".jar")) {
                    classworldsJar = file;
                    break;
                }
                ++n2;
            }
        }
        if (classworldsJar == null) {
            throw new IllegalArgumentException("Invalid maven home " + mavenHome);
        }
        this.classworldsJar = classworldsJar;
    }

    public int run(String[] cliArgs, Map<String, String> envVars, File workingDirectory, File logFile) throws IOException, LauncherException {
        String javaHome = envVars == null || envVars.get("JAVA_HOME") == null ? System.getProperty("java.home") : envVars.get("JAVA_HOME");
        File executable = new File(javaHome, Os.isFamily((String)"windows") ? "bin/javaw.exe" : "bin/java");
        CommandLine cli = new CommandLine(executable);
        cli.addArgument("-classpath").addArgument(this.classworldsJar.getAbsolutePath());
        cli.addArgument("-Dclassworlds.conf=" + new File(this.mavenHome, "bin/m2.conf").getAbsolutePath());
        cli.addArgument("-Dmaven.home=" + this.mavenHome.getAbsolutePath());
        cli.addArgument("org.codehaus.plexus.classworlds.launcher.Launcher");
        cli.addArguments(this.args.toArray(new String[this.args.size()]));
        if (this.extensions != null && !this.extensions.isEmpty()) {
            cli.addArgument("-Dmaven.ext.class.path=" + ForkedLauncher.toPath(this.extensions));
        }
        cli.addArguments(cliArgs);
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.mavenHome != null) {
            env.put("M2_HOME", this.mavenHome.getAbsolutePath());
        }
        if (envVars != null) {
            env.putAll(envVars);
        }
        if (envVars == null || envVars.get("JAVA_HOME") == null) {
            env.put("JAVA_HOME", System.getProperty("java.home"));
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        executor.setWorkingDirectory(workingDirectory.getAbsoluteFile());
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (FileOutputStream log = new FileOutputStream(logFile);){
                PrintStream out = new PrintStream(log);
                out.format("Maven Executor implementation: %s\n", this.getClass().getName());
                out.format("Maven home: %s\n", this.mavenHome);
                out.format("Build work directory: %s\n", workingDirectory);
                out.format("Environment: %s\n", env);
                out.format("Command line: %s\n\n", cli.toString());
                out.flush();
                PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)log);
                executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
                return executor.execute(cli, env);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ExecuteException e) {
            throw new LauncherException("Failed to run Maven: " + e.getMessage() + "\n" + cli, e);
        }
    }

    private static String toPath(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    @Override
    public int run(String[] cliArgs, File workingDirectory, File logFile) throws IOException, LauncherException {
        return this.run(cliArgs, this.envVars, workingDirectory, logFile);
    }

    @Override
    public String getMavenVersion() throws IOException, LauncherException {
        File logFile;
        try {
            logFile = File.createTempFile("maven", "log");
        }
        catch (IOException e) {
            throw new LauncherException("Error creating temp file", e);
        }
        Map<String, String> envVars = Collections.singletonMap("MAVEN_OPTS", "-Demma.rt.control=false");
        this.run(new String[]{"--version"}, envVars, new File(""), logFile);
        List<String> logLines = Files.readAllLines(logFile.toPath(), Charset.defaultCharset());
        logFile.delete();
        String version = ForkedLauncher.extractMavenVersion(logLines);
        if (version == null) {
            throw new LauncherException("Illegal Maven output: String 'Maven' not found in the following output:\n" + this.join(logLines, "\n"));
        }
        return version;
    }

    private String join(List<String> lines, String eol) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(eol);
        }
        return sb.toString();
    }

    static String extractMavenVersion(List<String> logLines) {
        String version = null;
        Pattern mavenVersion = Pattern.compile("(?i).*Maven.*? ([0-9]\\.\\S*).*");
        Iterator<String> it = logLines.iterator();
        while (version == null && it.hasNext()) {
            String line = it.next();
            Matcher m = mavenVersion.matcher(line);
            if (!m.matches()) continue;
            version = m.group(1);
        }
        return version;
    }
}

