/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import io.takari.maven.testing.TestProperties;
import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenLauncher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MavenExecution {
    private final MavenLauncher launcher;
    private final TestProperties properties;
    private final File basedir;
    private final List<String> cliOptions = new ArrayList<String>();

    MavenExecution(MavenLauncher launcher, TestProperties properties, File basedir) {
        this.launcher = launcher;
        this.properties = properties;
        this.basedir = basedir;
    }

    public MavenExecutionResult execute(String ... goals) throws Exception {
        File logFile = new File(this.basedir, "log.txt");
        ArrayList<String> args = new ArrayList<String>();
        File userSettings = this.properties.getUserSettings();
        if (userSettings != null && userSettings.isFile()) {
            args.add("-s");
            args.add(userSettings.getAbsolutePath());
        }
        args.add("-Dmaven.repo.local=" + this.properties.getLocalRepository().getAbsolutePath());
        args.add("-Dit-plugin.version=" + this.properties.getPluginVersion());
        args.addAll(this.cliOptions);
        String[] stringArray = goals;
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            String goal = stringArray[n2];
            args.add(goal);
            ++n2;
        }
        this.launcher.run(args.toArray(new String[args.size()]), this.basedir, logFile);
        return new MavenExecutionResult(this.basedir, logFile);
    }

    public MavenExecution withCliOption(String string) {
        this.cliOptions.add(string);
        return this;
    }

    public MavenExecution withCliOptions(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.cliOptions.add(string);
            ++n2;
        }
        return this;
    }
}

