/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.TestProperties;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.runners.model.InitializationError;
import org.xml.sax.InputSource;

abstract class MavenVersionResolver {
    private static final XPathFactory xpathFactory = XPathFactory.newInstance();

    MavenVersionResolver() {
    }

    public void resolve(String[] versions) throws Exception {
        Collection<URL> repositories = null;
        TestProperties properties = new TestProperties();
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            File basdir = new File("target/maven-installation").getCanonicalFile();
            File mavenHome = new File(basdir, "apache-maven-" + version).getCanonicalFile();
            if (!mavenHome.isDirectory()) {
                if (repositories == null) {
                    repositories = this.getRepositories(properties);
                }
                File archive = null;
                try {
                    archive = this.downloadMaven(properties.getLocalRepository(), repositories, version);
                }
                catch (Exception e) {
                    this.error(version, e);
                }
                if (archive != null) {
                    this.unarchive(archive, basdir);
                }
            }
            if (mavenHome.isDirectory()) {
                this.resolved(mavenHome, version);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unarchive(File archive, File directory) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TarArchiveInputStream ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(archive)));){
            while (true) {
                TarArchiveEntry entry;
                if ((entry = ais.getNextTarEntry()) == null) {
                    return;
                }
                if (!entry.isFile()) continue;
                String name = entry.getName();
                File file = new File(directory, name);
                file.getParentFile().mkdirs();
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                    this.copy((InputStream)ais, os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                int mode = entry.getMode();
                if (mode == -1 || (mode & 0x40) == 0) continue;
                try {
                    Path path = file.toPath();
                    Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(path, permissions);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private Collection<URL> getRepositories(TestProperties properties) throws Exception {
        LinkedHashSet<URL> repositories = new LinkedHashSet<URL>();
        for (String property : properties.getRepositories()) {
            InputSource is = new InputSource(new StringReader("<repository>" + property + "</repository>"));
            String url = this.getXPath(is, "/repository/url");
            if (url == null) continue;
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            repositories.add(new URL(url));
        }
        return repositories;
    }

    private String getXPath(InputSource is, String path) throws Exception {
        String value = xpathFactory.newXPath().compile(path).evaluate(is);
        if (value == null) {
            return null;
        }
        return !(value = value.trim()).isEmpty() ? value : null;
    }

    private File downloadMaven(File targetdir, Collection<URL> repositories, String version) throws Exception {
        String versionDir = "org/apache/maven/apache-maven/" + version + "/";
        String filename = "apache-maven-" + version + "-bin.tar.gz";
        File file = new File(targetdir, String.valueOf(versionDir) + filename);
        if (file.canRead()) {
            return file;
        }
        for (URL repository : repositories) {
            String effectiveVersion = version;
            if (version.endsWith("-SNAPSHOT")) {
                effectiveVersion = this.getQualifiedVersion(repository, versionDir);
            }
            if (effectiveVersion == null) continue;
            filename = "apache-maven-" + effectiveVersion + "-bin.tar.gz";
            file = new File(targetdir, String.valueOf(versionDir) + filename);
            if (file.canRead()) {
                return file;
            }
            URL resource = new URL(repository, String.valueOf(versionDir) + filename);
            try {
                Throwable throwable = null;
                Object var12_13 = null;
                try (InputStream is = this.openStream(resource);){
                    this.copy(is, file);
                    return file;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        throw new FileNotFoundException("Could not download maven version " + version + " from any configured repository");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQualifiedVersion(URL repository, String versionDir) throws Exception {
        resource = new URL(repository, String.valueOf(versionDir) + "maven-metadata.xml");
        try {
            var4_4 = null;
            var5_6 = null;
            try {
                is = this.openStream(resource);
                try {
                    buf = new ByteArrayOutputStream();
                    this.copy(is, buf);
                    xml = new InputSource(new ByteArrayInputStream(buf.toByteArray()));
                    version = this.getXPath(xml, "//metadata/versioning/snapshotVersions/snapshotVersion[extension='tar.gz']/value");
                    if (version == null) {
                        return null;
                    }
                    v0 = (version = version.trim()).isEmpty() != false ? null : version;
                    ** try [egrp 4[TRYBLOCK] [2 : 139->140)] { 
                }
lbl17:
                // 1 sources

                catch (Throwable var4_5) {
                    throw var4_5;
                }
                finally {
                    if (is == null) return null;
                    is.close();
                }
lbl16:
                // 1 sources

                return v0;
            }
            catch (Throwable var5_7) {
                if (var4_4 == null) {
                    var4_4 = var5_7;
                    throw var4_4;
                }
                if (var4_4 == var5_7) throw var4_4;
                var4_4.addSuppressed(var5_7);
                throw var4_4;
            }
        }
        catch (FileNotFoundException v1) {
            return null;
        }
    }

    private InputStream openStream(URL resource) throws IOException {
        URLConnection connection = resource.openConnection();
        connection.addRequestProperty("User-Agent", "takari-plugin-testing");
        return connection.getInputStream();
    }

    private void copy(InputStream from, File to) throws IOException {
        to.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(to);){
            this.copy(from, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = from.read(buf)) > 0) {
            to.write(buf, 0, len);
        }
    }

    protected abstract void error(String var1, Exception var2);

    protected abstract void resolved(File var1, String var2) throws InitializationError;
}

