/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.opentracing.Tracer;
import io.temporal.opentracing.SpanBuilderProvider;
import io.temporal.opentracing.SpanCreationContext;
import io.temporal.opentracing.SpanOperationType;
import java.util.Map;

public class ActionTypeAndNameSpanBuilderProvider
implements SpanBuilderProvider {
    public static final ActionTypeAndNameSpanBuilderProvider INSTANCE = new ActionTypeAndNameSpanBuilderProvider();
    private static final String PREFIX_DELIMITER = ":";

    @Override
    public Tracer.SpanBuilder createSpanBuilder(Tracer tracer, SpanCreationContext context) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(this.getSpanName(context));
        this.getSpanTags(context).forEach((arg_0, arg_1) -> ((Tracer.SpanBuilder)spanBuilder).withTag(arg_0, arg_1));
        return spanBuilder;
    }

    protected String getSpanName(SpanCreationContext context) {
        return context.getSpanOperationType().getDefaultPrefix() + PREFIX_DELIMITER + context.getActionName();
    }

    protected Map<String, String> getSpanTags(SpanCreationContext context) {
        SpanOperationType operationType = context.getSpanOperationType();
        switch (operationType) {
            case START_WORKFLOW: 
            case SIGNAL_WITH_START_WORKFLOW: {
                return ImmutableMap.of((Object)"workflowId", (Object)context.getWorkflowId());
            }
            case START_CHILD_WORKFLOW: {
                return ImmutableMap.of((Object)"workflowId", (Object)context.getWorkflowId(), (Object)"parentWorkflowId", (Object)context.getParentWorkflowId(), (Object)"parentRunId", (Object)context.getParentRunId());
            }
            case START_CONTINUE_AS_NEW_WORKFLOW: {
                return ImmutableMap.of((Object)"workflowId", (Object)context.getWorkflowId(), (Object)"parentRunId", (Object)context.getParentRunId());
            }
            case RUN_WORKFLOW: 
            case START_ACTIVITY: 
            case RUN_ACTIVITY: {
                String runId = context.getRunId();
                Preconditions.checkNotNull((Object)runId, (String)"runId is expected to be not null for span operation type %s", (Object)((Object)operationType));
                return ImmutableMap.of((Object)"workflowId", (Object)context.getWorkflowId(), (Object)"runId", (Object)context.getRunId());
            }
        }
        throw new IllegalArgumentException("Unknown span operation type provided");
    }
}

