/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import io.temporal.activity.DynamicActivity;
import io.temporal.common.metadata.POJOActivityImplMetadata;
import io.temporal.common.metadata.POJOActivityInterfaceMetadata;
import io.temporal.testing.TestActivityEnvironment;
import io.temporal.testing.TestEnvironmentOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class TestActivityExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private static final String TEST_ENVIRONMENT_KEY = "testEnvironment";
    private final TestEnvironmentOptions testEnvironmentOptions;
    private final Object[] activityImplementations;
    private final Set<Class<?>> supportedParameterTypes = new HashSet();
    private boolean includesDynamicActivity;

    private TestActivityExtension(Builder builder) {
        this.testEnvironmentOptions = builder.testEnvironmentOptions;
        this.activityImplementations = builder.activityImplementations;
        this.supportedParameterTypes.add(TestActivityEnvironment.class);
        for (Object activity : this.activityImplementations) {
            if (DynamicActivity.class.isAssignableFrom(activity.getClass())) {
                this.includesDynamicActivity = true;
                continue;
            }
            POJOActivityImplMetadata metadata = POJOActivityImplMetadata.newInstance(activity.getClass());
            for (POJOActivityInterfaceMetadata activityInterface : metadata.getActivityInterfaces()) {
                this.supportedParameterTypes.add(activityInterface.getInterfaceClass());
            }
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        if (parameter.getDeclaringExecutable() instanceof Constructor) {
            return false;
        }
        Class<?> parameterType = parameter.getType();
        if (this.supportedParameterTypes.contains(parameterType)) {
            return true;
        }
        if (!this.includesDynamicActivity) {
            return false;
        }
        try {
            POJOActivityInterfaceMetadata.newInstance(parameterType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestActivityEnvironment testEnvironment = this.getTestEnvironment(extensionContext);
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType == TestActivityEnvironment.class) {
            return testEnvironment;
        }
        return testEnvironment.newActivityStub(parameterType);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        TestActivityEnvironment testEnvironment = TestActivityEnvironment.newInstance(this.testEnvironmentOptions);
        testEnvironment.registerActivitiesImplementations(this.activityImplementations);
        this.setTestEnvironment(context, testEnvironment);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        TestActivityEnvironment testEnvironment = this.getTestEnvironment(context);
        testEnvironment.close();
    }

    private TestActivityEnvironment getTestEnvironment(ExtensionContext context) {
        return (TestActivityEnvironment)this.getStore(context).get((Object)TEST_ENVIRONMENT_KEY, TestActivityEnvironment.class);
    }

    private void setTestEnvironment(ExtensionContext context, TestActivityEnvironment testEnvironment) {
        this.getStore(context).put((Object)TEST_ENVIRONMENT_KEY, (Object)testEnvironment);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{TestActivityExtension.class, context.getRequiredTestMethod()});
        return context.getStore(namespace);
    }

    public static class Builder {
        private static final Object[] NO_ACTIVITIES = new Object[0];
        private TestEnvironmentOptions testEnvironmentOptions = TestEnvironmentOptions.getDefaultInstance();
        private Object[] activityImplementations = NO_ACTIVITIES;

        private Builder() {
        }

        public Builder setTestEnvironmentOptions(TestEnvironmentOptions testEnvironmentOptions) {
            this.testEnvironmentOptions = testEnvironmentOptions;
            return this;
        }

        public Builder setActivityImplementations(Object ... activityImplementations) {
            this.activityImplementations = activityImplementations;
            return this;
        }

        public TestActivityExtension build() {
            return new TestActivityExtension(this);
        }
    }
}

