/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.opentelemetry.HeadersPropagatorGetter;
import io.vertx.tracing.opentelemetry.HeadersPropagatorSetter;
import io.vertx.tracing.opentelemetry.OpenTelemetryTracingFactory;
import io.vertx.tracing.opentelemetry.Operation;
import io.vertx.tracing.opentelemetry.VertxContextStorageProvider;
import java.util.Map;
import java.util.function.BiConsumer;

class OpenTelemetryTracer
implements VertxTracer<Operation, Operation> {
    private static final TextMapGetter<Iterable<Map.Entry<String, String>>> getter = new HeadersPropagatorGetter();
    private static final TextMapSetter<BiConsumer<String, String>> setter = new HeadersPropagatorSetter();
    private final Tracer tracer;
    private final ContextPropagators propagators;

    OpenTelemetryTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("io.vertx");
        this.propagators = openTelemetry.getPropagators();
    }

    public <R> Operation receiveRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy)) {
            return null;
        }
        ContextInternal ctx = (ContextInternal)context;
        Context otelCtx = (Context)ctx.getLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT);
        if (otelCtx == null) {
            otelCtx = Context.root();
        }
        if (Span.fromContextOrNull((Context)(otelCtx = this.propagators.getTextMapPropagator().extract(otelCtx, headers, getter))) == null && TracingPolicy.PROPAGATE.equals((Object)policy)) {
            return null;
        }
        SpanKind spanKind = io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.SERVER : SpanKind.CONSUMER;
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operation).setParent(otelCtx).setSpanKind(spanKind);
        Span span = this.reportTagsAndStart(spanBuilder, request, tagExtractor, false);
        Scope scope = VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(ctx, span.storeInContext(otelCtx));
        return new Operation(span, scope);
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, Operation operation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (operation != null) {
            OpenTelemetryTracer.end(operation, response, tagExtractor, failure, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> void end(Operation operation, R response, TagExtractor<R> tagExtractor, Throwable failure, boolean client) {
        Span span = operation.span();
        try {
            if (failure != null) {
                span.recordException(failure);
            }
            if (response != null) {
                Attributes attributes = OpenTelemetryTracer.processTags(response, tagExtractor, client);
                span.setAllAttributes(attributes);
            }
            span.end();
        }
        finally {
            operation.scope().close();
        }
    }

    public <R> Operation sendRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy) || request == null) {
            return null;
        }
        Context otelCtx = (Context)((ContextInternal)context).getLocal(OpenTelemetryTracingFactory.ACTIVE_CONTEXT);
        if (otelCtx == null) {
            if (!TracingPolicy.ALWAYS.equals((Object)policy)) {
                return null;
            }
            otelCtx = Context.root();
        }
        SpanKind spanKind = io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER;
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operation).setParent(otelCtx).setSpanKind(spanKind);
        Span span = this.reportTagsAndStart(spanBuilder, request, tagExtractor, true);
        otelCtx = otelCtx.with((ImplicitContextKeyed)span);
        this.propagators.getTextMapPropagator().inject(otelCtx, headers, setter);
        return new Operation(span, Scope.noop());
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, Operation operation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (operation != null) {
            OpenTelemetryTracer.end(operation, response, tagExtractor, failure, true);
        }
    }

    private <T> Span reportTagsAndStart(SpanBuilder span, T obj, TagExtractor<T> tagExtractor, boolean client) {
        Attributes attributes = OpenTelemetryTracer.processTags(obj, tagExtractor, client);
        span.setAllAttributes(attributes);
        return span.startSpan();
    }

    private static <T> Attributes processTags(T obj, TagExtractor<T> tagExtractor, boolean client) {
        AttributesBuilder builder = Attributes.builder();
        int len = tagExtractor.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            builder.put(tagExtractor.name(obj, idx), tagExtractor.value(obj, idx));
        }
        return builder.build();
    }
}

