/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2ByteMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Object2ByteOpenCustomHashMap<K>
extends AbstractObject2ByteMap<K>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Object2ByteMap.FastEntrySet<K> entries;
    protected volatile transient ObjectSet<K> keys;
    protected volatile transient ByteCollection values;
    protected Hash.Strategy<K> strategy;

    public Object2ByteOpenCustomHashMap(int expected, float f, Hash.Strategy<K> strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
    }

    public Object2ByteOpenCustomHashMap(int expected, Hash.Strategy<K> strategy) {
        this(expected, 0.75f, strategy);
    }

    public Object2ByteOpenCustomHashMap(Hash.Strategy<K> strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2ByteOpenCustomHashMap(Map<? extends K, ? extends Byte> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ByteOpenCustomHashMap(Map<? extends K, ? extends Byte> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ByteOpenCustomHashMap(Object2ByteMap<K> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ByteOpenCustomHashMap(Object2ByteMap<K> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ByteOpenCustomHashMap(K[] k, byte[] v, float f, Hash.Strategy<K> strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2ByteOpenCustomHashMap(K[] k, byte[] v, Hash.Strategy<K> strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy<K> strategy() {
        return this.strategy;
    }

    @Override
    public byte put(K k, byte v) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(K ok, Byte ov) {
        byte v = ov;
        K k = ok;
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public byte add(K k, byte incr) {
        return this.addTo(k, incr);
    }

    public byte addTo(K k, byte incr) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.strategy.hashCode(this.key[pos]) ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.key[last] = null;
        return last;
    }

    @Override
    public byte removeByte(Object k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        Object k = ok;
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte getByte(Object k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Object2ByteMap.FastEntrySet<K> object2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                @Override
                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Object2ByteOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(byte v) {
                    return Object2ByteOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Object2ByteOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        K[] key = this.key;
        byte[] value = this.value;
        int mask = newN - 1;
        Object[] newKey = new Object[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            K k = key[i];
            int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Object2ByteOpenCustomHashMap<K> clone() {
        Object2ByteOpenCustomHashMap c;
        try {
            c = (Object2ByteOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.strategy.hashCode(this.key[i]);
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            byte v = s.readByte();
            pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteIterator {
        @Override
        public byte nextByte() {
            return Object2ByteOpenCustomHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Byte next() {
            return Object2ByteOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractObjectSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ByteOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Object2ByteOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Object2ByteOpenCustomHashMap.this.size;
            Object2ByteOpenCustomHashMap.this.remove(k);
            return Object2ByteOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Object2ByteOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator<K> {
        @Override
        public K next() {
            return Object2ByteOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Object2ByteMap.Entry<K>>
    implements Object2ByteMap.FastEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Object2ByteMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Object2ByteMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = HashCommon.murmurHash3(Object2ByteOpenCustomHashMap.this.strategy.hashCode(k) ^ Object2ByteOpenCustomHashMap.this.mask) & Object2ByteOpenCustomHashMap.this.mask;
            while (Object2ByteOpenCustomHashMap.this.used[pos]) {
                if (Object2ByteOpenCustomHashMap.this.strategy.equals(Object2ByteOpenCustomHashMap.this.key[pos], k)) {
                    return Object2ByteOpenCustomHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Object2ByteOpenCustomHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = HashCommon.murmurHash3(Object2ByteOpenCustomHashMap.this.strategy.hashCode(k) ^ Object2ByteOpenCustomHashMap.this.mask) & Object2ByteOpenCustomHashMap.this.mask;
            while (Object2ByteOpenCustomHashMap.this.used[pos]) {
                if (Object2ByteOpenCustomHashMap.this.strategy.equals(Object2ByteOpenCustomHashMap.this.key[pos], k)) {
                    Object2ByteOpenCustomHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Object2ByteOpenCustomHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Object2ByteOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Object2ByteOpenCustomHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ByteMap.Entry<K>> {
        final AbstractObject2ByteMap.BasicEntry<K> entry;

        private FastEntryIterator() {
            this.entry = new AbstractObject2ByteMap.BasicEntry<Object>(null, 0);
        }

        @Override
        public AbstractObject2ByteMap.BasicEntry<K> next() {
            int e = this.nextEntry();
            this.entry.key = Object2ByteOpenCustomHashMap.this.key[e];
            this.entry.value = Object2ByteOpenCustomHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ByteMap.Entry<K>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Object2ByteMap.Entry<K> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        ObjectArrayList<K> wrapped;

        private MapIterator() {
            this.pos = Object2ByteOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Object2ByteOpenCustomHashMap.this.size;
            boolean[] used = Object2ByteOpenCustomHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                Object k = this.wrapped.get(-this.pos - 2);
                int pos = HashCommon.murmurHash3(Object2ByteOpenCustomHashMap.this.strategy.hashCode(k) ^ Object2ByteOpenCustomHashMap.this.mask) & Object2ByteOpenCustomHashMap.this.mask;
                while (Object2ByteOpenCustomHashMap.this.used[pos]) {
                    if (Object2ByteOpenCustomHashMap.this.strategy.equals(Object2ByteOpenCustomHashMap.this.key[pos], k)) {
                        return pos;
                    }
                    pos = pos + 1 & Object2ByteOpenCustomHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Object2ByteOpenCustomHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Object2ByteOpenCustomHashMap.this.mask;
                while (Object2ByteOpenCustomHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Object2ByteOpenCustomHashMap.this.strategy.hashCode(Object2ByteOpenCustomHashMap.this.key[pos]) ^ Object2ByteOpenCustomHashMap.this.mask) & Object2ByteOpenCustomHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Object2ByteOpenCustomHashMap.this.mask;
                }
                if (!Object2ByteOpenCustomHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ObjectArrayList();
                    }
                    this.wrapped.add(Object2ByteOpenCustomHashMap.this.key[pos]);
                }
                Object2ByteOpenCustomHashMap.this.key[last] = Object2ByteOpenCustomHashMap.this.key[pos];
                Object2ByteOpenCustomHashMap.this.value[last] = Object2ByteOpenCustomHashMap.this.value[pos];
            }
            Object2ByteOpenCustomHashMap.this.used[last] = false;
            Object2ByteOpenCustomHashMap.this.key[last] = null;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Object2ByteOpenCustomHashMap.this.remove(this.wrapped.set(-this.pos - 2, (Object)null));
                this.last = -1;
                return;
            }
            --Object2ByteOpenCustomHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Object2ByteMap.Entry<K>,
    Map.Entry<K, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2ByteOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Object2ByteOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Object2ByteOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Object2ByteOpenCustomHashMap.this.value[this.index];
            Object2ByteOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2ByteOpenCustomHashMap.this.strategy.equals(Object2ByteOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2ByteOpenCustomHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return Object2ByteOpenCustomHashMap.this.strategy.hashCode(Object2ByteOpenCustomHashMap.this.key[this.index]) ^ Object2ByteOpenCustomHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2ByteOpenCustomHashMap.this.key[this.index] + "=>" + Object2ByteOpenCustomHashMap.this.value[this.index];
        }
    }
}

