/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.odf;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.DecoratingOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.MutableEntry;
import net.java.truecommons.cio.OutputSocket;
import net.java.truevfs.comp.zipdriver.JarDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;

@NotThreadSafe
public class OdfOutputService
extends MultiplexingOutputService<JarDriverEntry> {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    public OdfOutputService(IoBufferPool pool, @WillCloseWhenClosed ZipOutputService<JarDriverEntry> output) {
        super(pool, output);
    }

    public OutputSocket<JarDriverEntry> output(final JarDriverEntry entry) {
        Objects.requireNonNull(entry);
        final class Output
        extends DecoratingOutputSocket<JarDriverEntry> {
            Output() {
                super(OdfOutputService.super.output((MutableEntry)jarDriverEntry));
            }

            public JarDriverEntry target() throws IOException {
                return entry;
            }

            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (OdfOutputService.MIMETYPE.equals(entry.getName())) {
                    OdfOutputService.this.mimetype = true;
                    if (-1 == entry.getMethod()) {
                        entry.setMethod(0);
                    }
                }
                return this.socket().stream(peer);
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return !this.mimetype || super.isBusy();
    }

    @DischargesObligation
    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

