/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.PowerBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.io.Source;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.driver.zip.raes.crypto.RaesAuthenticationException;
import net.java.truevfs.driver.zip.raes.crypto.RaesException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersProvider;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesReadOnlyChannel;

@NotThreadSafe
public abstract class RaesReadOnlyChannel
extends ReadOnlyChannel {
    @CreatesObligation
    public static RaesReadOnlyChannel create(RaesParameters param, Source source) throws RaesParametersException, RaesException, EOFException, IOException {
        SeekableByteChannel channel = source.channel();
        try {
            return RaesReadOnlyChannel.create(param, channel);
        }
        catch (Throwable ex) {
            try {
                channel.close();
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    @CreatesObligation
    private static RaesReadOnlyChannel create(RaesParameters param, @WillCloseWhenClosed SeekableByteChannel channel) throws RaesParametersException, RaesException, EOFException, IOException {
        PowerBuffer header = PowerBuffer.allocate((int)5).littleEndian().load((ReadableByteChannel)channel.position(0L));
        if (1397047634L != header.getUInt()) {
            throw new RaesException("No RAES signature!");
        }
        int type = header.getUByte();
        if (type != 0) {
            throw new RaesException("Unknown RAES type: " + type);
        }
        return new Type0RaesReadOnlyChannel(RaesReadOnlyChannel.parameters(Type0RaesParameters.class, param), channel);
    }

    private static <P extends RaesParameters> P parameters(Class<P> type, @CheckForNull RaesParameters param) throws RaesParametersException {
        while (null != param) {
            if (type.isInstance(param)) {
                return (P)((RaesParameters)type.cast(param));
            }
            if (!(param instanceof RaesParametersProvider)) break;
            param = ((RaesParametersProvider)param).get(type);
        }
        throw new RaesParametersException("No suitable RAES parameters available!");
    }

    public abstract AesKeyStrength getKeyStrength();

    public abstract void authenticate() throws RaesAuthenticationException, IOException;
}

