/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.AbstractStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.events.DeviceEventType;
import net.samuelcampos.usbdrivedetector.events.IUSBDriveListener;
import net.samuelcampos.usbdrivedetector.events.USBStorageEvent;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USBDeviceDetectorManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(USBDeviceDetectorManager.class);
    private static final long DEFAULT_POLLING_INTERVAL_MILLIS = 5000L;
    private final Set<USBStorageDevice> connectedDevices;
    private final List<IUSBDriveListener> listeners = new ArrayList<IUSBDriveListener>();
    private long currentPollingInterval;
    private final ScheduledExecutorService taskExecutor;
    private ScheduledFuture<?> listenerTaskFuture;

    public USBDeviceDetectorManager() {
        this(5000L);
    }

    public USBDeviceDetectorManager(long pollingInterval) {
        this.connectedDevices = new HashSet<USBStorageDevice>();
        this.currentPollingInterval = pollingInterval;
        this.taskExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public USBDeviceDetectorManager(long pollingInterval, AbstractStorageDeviceDetector customDeviceDetector) {
        this(pollingInterval);
        AbstractStorageDeviceDetector.setInstance(customDeviceDetector);
    }

    public synchronized void setPollingInterval(long pollingInterval) {
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("'pollingInterval' must be greater than 0");
        }
        this.currentPollingInterval = pollingInterval;
        if (!this.listeners.isEmpty()) {
            this.stop();
            this.start();
        }
    }

    private synchronized void start() {
        if (this.listenerTaskFuture == null || this.listenerTaskFuture.isDone()) {
            this.listenerTaskFuture = this.taskExecutor.scheduleAtFixedRate(new ListenerTask(), 0L, this.currentPollingInterval, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void stop() {
        if (this.listenerTaskFuture != null) {
            this.listenerTaskFuture.cancel(false);
        }
    }

    public synchronized boolean addDriveListener(IUSBDriveListener listener) {
        if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        this.start();
        return true;
    }

    public synchronized boolean removeDriveListener(IUSBDriveListener listener) {
        boolean removed = this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
        return removed;
    }

    public List<USBStorageDevice> getRemovableDevices() {
        return AbstractStorageDeviceDetector.getInstance().getStorageDevices();
    }

    public void unmountStorageDevice(USBStorageDevice usbStorageDevice) throws IOException {
        AbstractStorageDeviceUnmounter.getInstance().unmount(usbStorageDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectedDevices(List<USBStorageDevice> currentConnectedDevices) {
        ArrayList<USBStorageDevice> removedDevices = new ArrayList<USBStorageDevice>();
        USBDeviceDetectorManager uSBDeviceDetectorManager = this;
        synchronized (uSBDeviceDetectorManager) {
            Iterator<USBStorageDevice> itConnectedDevices = this.connectedDevices.iterator();
            while (itConnectedDevices.hasNext()) {
                USBStorageDevice device2 = itConnectedDevices.next();
                if (currentConnectedDevices.contains(device2)) {
                    currentConnectedDevices.remove(device2);
                    continue;
                }
                removedDevices.add(device2);
                itConnectedDevices.remove();
            }
            this.connectedDevices.addAll(currentConnectedDevices);
        }
        currentConnectedDevices.forEach(device -> this.sendEventToListeners(new USBStorageEvent((USBStorageDevice)device, DeviceEventType.CONNECTED)));
        removedDevices.forEach(device -> this.sendEventToListeners(new USBStorageEvent((USBStorageDevice)device, DeviceEventType.REMOVED)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventToListeners(USBStorageEvent event) {
        ArrayList<IUSBDriveListener> listenersCopy;
        List<IUSBDriveListener> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<IUSBDriveListener>(this.listeners);
        }
        for (IUSBDriveListener listener : listenersCopy) {
            try {
                listener.usbDriveEvent(event);
            }
            catch (Exception ex) {
                log.error("An IUSBDriveListener threw an exception", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.taskExecutor.shutdown();
        try {
            this.taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Unable to wait for taskExecutor termination", (Throwable)e);
        }
    }

    private class ListenerTask
    implements Runnable {
        private ListenerTask() {
        }

        @Override
        public void run() {
            try {
                log.trace("Polling refresh task is running");
                List<USBStorageDevice> actualConnectedDevices = USBDeviceDetectorManager.this.getRemovableDevices();
                USBDeviceDetectorManager.this.updateConnectedDevices(actualConnectedDevices);
            }
            catch (Exception e) {
                log.error("Error while refreshing device list", (Throwable)e);
            }
        }
    }
}

