/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.samuelcampos.usbdrivedetector.process.OutputProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandOutputProcessor
extends OutputProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommandOutputProcessor.class);
    private final String command;
    private final Process process;

    public CommandOutputProcessor(String command, Process process) {
        super(new BufferedReader(new InputStreamReader(process.getInputStream())));
        this.command = command;
        this.process = process;
    }

    @Override
    public void close() throws IOException {
        try {
            int exitValue = this.process.waitFor();
            if (exitValue != 0) {
                log.warn("Abnormal command '{}' termination. Exit value: {}", (Object)this.command, (Object)exitValue);
            }
        }
        catch (InterruptedException e) {
            log.error("Error while waiting for command '{}' to complete", (Object)this.command, (Object)e);
        }
        super.closeInput();
        this.process.destroy();
    }
}

