/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import ch.lambdaj.Lambda;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.ExecutorServiceProvider;
import net.thucydides.core.reports.FlagsAugmenter;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeAugmenter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportLoadingFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcomeLoader {
    private final EnvironmentVariables environmentVariables;
    private final FormatConfiguration formatConfiguration;
    private final ExecutorService executor;
    private static final Logger logger = LoggerFactory.getLogger(TestOutcomeLoader.class);
    private static final List<? extends OutcomeAugmenter> AUGMENTERS = ImmutableList.of((Object)new FlagsAugmenter());

    public TestOutcomeLoader() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Inject
    public TestOutcomeLoader(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new FormatConfiguration(environmentVariables));
    }

    public TestOutcomeLoader(EnvironmentVariables environmentVariables, FormatConfiguration formatConfiguration) {
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = formatConfiguration;
        this.executor = ((ExecutorServiceProvider)Injectors.getInjector().getInstance(ExecutorServiceProvider.class)).getExecutorService();
    }

    public TestOutcomeLoader forFormat(OutcomeFormat format) {
        return new TestOutcomeLoader(this.environmentVariables, new FormatConfiguration(format));
    }

    public List<TestOutcome> loadFrom(File reportDirectory) throws ReportLoadingFailedError {
        try {
            List partitions = Lists.newArrayList();
            AcceptanceTestLoader testOutcomeReporter = this.getOutcomeReporter();
            for (File sourceFile : this.getAllOutcomeFilesFrom(reportDirectory)) {
                partitions.add(new TestOutcomeLoaderCallable(testOutcomeReporter, sourceFile));
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(20);
            List loadedTestOutcomes = executorPool.invokeAll(partitions);
            List testOutcomes = Lists.newArrayList();
            for (Future loadedTestOutcome : loadedTestOutcomes) {
                testOutcomes.addAll((Collection)loadedTestOutcome.get());
            }
            executorPool.shutdown();
            return TestOutcomeLoader.inOrderOfTestExecution(testOutcomes);
        }
        catch (Exception e) {
            throw new ReportLoadingFailedError("Can not load reports for some reason", e);
        }
    }

    private List<File> getAllOutcomeFilesFrom(File reportsDirectory) throws IOException {
        Object[] matchingFiles = reportsDirectory.listFiles(new SerializedOutcomeFilenameFilter());
        if (matchingFiles == null) {
            throw new IOException("Could not find directory " + reportsDirectory);
        }
        return ImmutableList.copyOf((Object[])matchingFiles);
    }

    private DirectoryStream.Filter<? super Path> thatContainsTestOutcomeFiles() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String standardFormatFilename = entry.getFileName().toString().toLowerCase(Locale.getDefault());
                return standardFormatFilename.endsWith(TestOutcomeLoader.this.formatConfiguration.getPreferredFormat().getExtension()) && !standardFormatFilename.endsWith(".features.json") && !standardFormatFilename.startsWith("SERENITY-JUNIT-");
            }
        };
    }

    public static TestOutcomeLoaderBuilder loadTestOutcomes() {
        return new TestOutcomeLoaderBuilder();
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    private static List<TestOutcome> inOrderOfTestExecution(List<TestOutcome> testOutcomes) {
        return Lambda.sort(testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getStartTime());
    }

    public AcceptanceTestLoader getOutcomeReporter() {
        switch (this.formatConfiguration.getPreferredFormat()) {
            case XML: {
                return new XMLTestOutcomeReporter();
            }
            case JSON: {
                return new JSONTestOutcomeReporter();
            }
        }
        throw new IllegalArgumentException("Unsupported report format: " + (Object)((Object)this.formatConfiguration.getPreferredFormat()));
    }

    private class SerializedOutcomeFilenameFilter
    implements FilenameFilter {
        private SerializedOutcomeFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(TestOutcomeLoader.this.formatConfiguration.getPreferredFormat().getExtension()) && !filename.endsWith(".features.json") && !filename.startsWith("SERENITY-JUNIT-");
        }
    }

    public static final class TestOutcomeLoaderBuilder {
        OutcomeFormat format;

        public TestOutcomeLoaderBuilder inFormat(OutcomeFormat format) {
            this.format = format;
            return this;
        }

        public TestOutcomes from(File reportsDirectory) throws IOException {
            TestOutcomeLoader loader = new TestOutcomeLoader().forFormat(this.format);
            return TestOutcomes.of(loader.loadFrom(reportsDirectory));
        }
    }

    class TestOutcomeLoaderCallable
    implements Callable<Set<TestOutcome>> {
        private final File sourceFile;
        private final AcceptanceTestLoader testOutcomeReporter;

        TestOutcomeLoaderCallable(AcceptanceTestLoader testOutcomeReporter, File sourceFile) {
            this.testOutcomeReporter = testOutcomeReporter;
            this.sourceFile = sourceFile;
        }

        @Override
        public Set<TestOutcome> call() throws Exception {
            Optional<TestOutcome> loadedTestOutcome = this.testOutcomeReporter.loadReportFrom(this.sourceFile);
            if (loadedTestOutcome.isPresent()) {
                return ImmutableSet.of((Object)this.augmented((TestOutcome)loadedTestOutcome.get()));
            }
            return ImmutableSet.of();
        }

        private TestOutcome augmented(TestOutcome testOutcome) {
            for (OutcomeAugmenter augmenter : AUGMENTERS) {
                testOutcome = augmenter.augment(testOutcome);
            }
            return testOutcome;
        }
    }
}

