/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import java.security.NoSuchAlgorithmException;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StringDigesterTest {
    private StringDigester digester;

    @Test
    public void testBasic() throws NoSuchAlgorithmException {
        String input = "foobarbaz";
        this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.BASE64);
        Assert.assertEquals((String)this.digester.apply(input), (String)"X1UT+IIv2+UUWvM7ZNjZcNz5XG4=");
        this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER);
        Assert.assertEquals((String)this.digester.apply(input), (String)"5f5513f8822fdbe5145af33b64d8d970dcf95c6e");
        this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_UPPER);
        Assert.assertEquals((String)this.digester.apply(input), (String)"5F5513F8822FDBE5145AF33B64D8D970DCF95C6E");
        this.digester = new StringDigester("SHA-1", StringDigester.OutputFormat.BASE64);
        Assert.assertNull((Object)this.digester.apply("     "));
    }

    @Test(expectedExceptions={NoSuchAlgorithmException.class})
    public void testInvalidAlgorithm() throws NoSuchAlgorithmException {
        this.digester = new StringDigester("bogus", StringDigester.OutputFormat.BASE64);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullOrEmptyAlgorithm() throws NoSuchAlgorithmException {
        this.digester = new StringDigester("   ", StringDigester.OutputFormat.BASE64);
    }
}

