/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpServletRequestResponseContextTest {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test
    public void testLoadAndClear() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Assert.assertNotNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNotNull((Object)HttpServletRequestResponseContext.getResponse());
        Assert.assertEquals((String)HttpServletRequestResponseContext.getRequest().getMethod(), (String)"GET");
        Assert.assertEquals((String)HttpServletRequestResponseContext.getRequest().getRequestURI(), (String)"/foo");
        Assert.assertEquals((String)HttpServletRequestResponseContext.getRequest().getHeader("MyRequestHeader"), (String)"MyRequestHeaderValue");
        Assert.assertEquals((String)HttpServletRequestResponseContext.getRequest().getParameter("MyParam"), (String)"MyParamValue");
        Assert.assertTrue((boolean)HttpServletRequestResponseContext.getResponse().containsHeader("MyResponseHeader"));
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }
}

