/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.jsp.rule.basic;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.jsp.ast.ASTJspDirectiveAttribute;
import net.sourceforge.pmd.lang.jsp.rule.AbstractJspRule;
import net.sourceforge.pmd.lang.rule.ImportWrapper;

public class DuplicateJspImportsRule
extends AbstractJspRule {
    private Set<ImportWrapper> imports = new HashSet<ImportWrapper>();

    @Override
    public void apply(List<? extends Node> nodes, RuleContext ctx) {
        this.imports.clear();
        super.apply(nodes, ctx);
    }

    @Override
    public Object visit(ASTJspDirectiveAttribute node, Object data) {
        if (!"import".equals(node.getName())) {
            return super.visit(node, data);
        }
        String values = node.getValue();
        StringTokenizer st = new StringTokenizer(values, ",");
        int count = st.countTokens();
        for (int ix = 0; ix < count; ++ix) {
            String token = st.nextToken();
            ImportWrapper wrapper = new ImportWrapper(token, token, (Node)node);
            if (this.imports.contains(wrapper)) {
                this.addViolation(data, node, node.getImage());
                continue;
            }
            this.imports.add(wrapper);
        }
        return super.visit(node, data);
    }
}

