/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher;

import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.Map;
import net.sqlcipher.CursorWindow;
import net.sqlcipher.DatabaseUtils;
import net.sqlcipher.IBulkCursor;
import net.sqlcipher.IContentObserver;

final class BulkCursorProxy
implements IBulkCursor {
    private IBinder mRemote;
    private Bundle mExtras;

    public BulkCursorProxy(IBinder remote) {
        this.mRemote = remote;
        this.mExtras = null;
    }

    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public CursorWindow getWindow(int startPos) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeInt(startPos);
        this.mRemote.transact(1, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        CursorWindow window = null;
        if (reply.readInt() == 1) {
            window = CursorWindow.newFromParcel(reply);
        }
        data.recycle();
        reply.recycle();
        return window;
    }

    @Override
    public void onMove(int position) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeInt(position);
        this.mRemote.transact(8, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        data.recycle();
        reply.recycle();
    }

    @Override
    public int count() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        boolean result = this.mRemote.transact(2, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = !result ? -1 : reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    @Override
    public String[] getColumnNames() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(3, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        String[] columnNames = null;
        int numColumns = reply.readInt();
        columnNames = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnNames[i] = reply.readString();
        }
        data.recycle();
        reply.recycle();
        return columnNames;
    }

    @Override
    public void deactivate() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(6, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        data.recycle();
        reply.recycle();
    }

    @Override
    public void close() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(12, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        data.recycle();
        reply.recycle();
    }

    @Override
    public int requery(IContentObserver observer, CursorWindow window) throws RemoteException {
        int count;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeStrongInterface((IInterface)observer);
        window.writeToParcel(data, 0);
        boolean result = this.mRemote.transact(7, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        if (!result) {
            count = -1;
        } else {
            count = reply.readInt();
            this.mExtras = reply.readBundle(this.getClass().getClassLoader());
        }
        data.recycle();
        reply.recycle();
        return count;
    }

    public boolean updateRows(Map values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeMap(values);
        this.mRemote.transact(4, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        boolean result = reply.readInt() == 1;
        data.recycle();
        reply.recycle();
        return result;
    }

    @Override
    public boolean deleteRow(int position) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeInt(position);
        this.mRemote.transact(5, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        boolean result = reply.readInt() == 1;
        data.recycle();
        reply.recycle();
        return result;
    }

    @Override
    public boolean getWantsAllOnMoveCalls() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(9, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int result = reply.readInt();
        data.recycle();
        reply.recycle();
        return result != 0;
    }

    @Override
    public Bundle getExtras() throws RemoteException {
        if (this.mExtras == null) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(10, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            this.mExtras = reply.readBundle(this.getClass().getClassLoader());
            data.recycle();
            reply.recycle();
        }
        return this.mExtras;
    }

    @Override
    public Bundle respond(Bundle extras) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IBulkCursor");
        data.writeBundle(extras);
        this.mRemote.transact(11, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        Bundle returnExtras = reply.readBundle(this.getClass().getClassLoader());
        data.recycle();
        reply.recycle();
        return returnExtras;
    }
}

