/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.expressionprocessor;

import groovy.transform.Generated;
import java.util.HashSet;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class ExpressionProcessor {
    private static final Logger logger;
    private static final HashSet<String> oldFragmentExpressions;
    private final IExpressionContext context;

    @Generated
    public ExpressionProcessor(IExpressionContext context) {
        IExpressionContext iExpressionContext;
        this.context = iExpressionContext = context;
    }

    public IStandardExpression parse(String expression) {
        return StandardExpressions.getExpressionParser((IEngineConfiguration)this.context.getConfiguration()).parseExpression(this.context, expression);
    }

    public FragmentExpression parseFragmentExpression(String expression) {
        if (DefaultTypeTransformation.booleanUnbox((Object)expression) && !ScriptBytecodeAdapter.matchRegex((Object)expression, (Object)"(?s)^~\\{.+\\}$")) {
            if (!oldFragmentExpressions.contains(expression)) {
                logger.warn(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Fragment expression \"{}\" is being wrapped as a Thymeleaf 3 fragment expression (~{...}) for backwards compatibility purposes.  ", (CharSequence)"This wrapping will be dropped in the next major version of the expression processor, so please rewrite as a Thymeleaf 3 fragment expression to future-proof your code.  "), (CharSequence)"See https://github.com/thymeleaf/thymeleaf/issues/451 for more information."), expression);
                DefaultGroovyMethods.leftShift(oldFragmentExpressions, (Object)expression);
            }
            expression = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{expression}, new String[]{"~{", "}"}));
        }
        return (FragmentExpression)IndyInterface.bootstrap("invoke", "asType", 0, this.parse((String)expression), FragmentExpression.class);
    }

    public Object process(String expression) {
        return this.parse(expression).execute(this.context);
    }

    public String processAsString(String expression) {
        return DefaultGroovyMethods.toString((Object)this.process(expression));
    }

    static {
        Logger logger;
        ExpressionProcessor.logger = logger = LoggerFactory.getLogger(ExpressionProcessor.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        oldFragmentExpressions = IndyInterface.bootstrap("cast", "()", 0, list);
    }

    @Generated
    public final IExpressionContext getContext() {
        return this.context;
    }
}

