/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChmodCommand
extends AbstractShellCommand {
    public ChmodCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "chmod";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    protected Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chmod(AlluxioURI path, String modeStr, boolean recursive) throws IOException {
        short newPermission = 0;
        try {
            newPermission = Short.parseShort(modeStr, 8);
            SetAttributeOptions options = SetAttributeOptions.defaults().setPermission(newPermission).setRecursive(recursive);
            this.mFileSystem.setAttribute(path, options);
            System.out.println("Changed permission of " + path + " to " + Integer.toOctalString(newPermission));
        }
        catch (Exception e) {
            throw new IOException("Failed to changed permission of  " + path + " to " + Integer.toOctalString(newPermission) + " : " + e.getMessage());
        }
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        String modeStr = args[0];
        AlluxioURI path = new AlluxioURI(args[1]);
        this.chmod(path, modeStr, cl.hasOption("R"));
    }

    @Override
    public String getUsage() {
        return "chmod -R <mode> <path>";
    }

    @Override
    public String getDescription() {
        return "Changes the permission of a file or directory specified by args. Specify -R to change the permission recursively.";
    }
}

