/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChownCommand
extends AbstractShellCommand {
    public ChownCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "chown";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    protected Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chown(AlluxioURI path, String owner, boolean recursive) throws IOException {
        try {
            SetAttributeOptions options = SetAttributeOptions.defaults().setOwner(owner).setRecursive(recursive);
            this.mFileSystem.setAttribute(path, options);
            System.out.println("Changed owner of " + path + " to " + owner);
        }
        catch (AlluxioException e) {
            throw new IOException("Failed to changed owner of " + path + " to " + owner + " : " + e.getMessage());
        }
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        String owner = args[0];
        AlluxioURI path = new AlluxioURI(args[1]);
        this.chown(path, owner, cl.hasOption("R"));
    }

    @Override
    public String getUsage() {
        return "chown -R <owner> <path>";
    }

    @Override
    public String getDescription() {
        return "Changes the owner of a file or directory specified by args. Specify -R to change the owner recursively.";
    }
}

