/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.exception.AlluxioException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CommandUtils {
    private CommandUtils() {
    }

    public static void setTtl(FileSystem fs, AlluxioURI path, long ttlMs) throws IOException {
        try {
            SetAttributeOptions options = SetAttributeOptions.defaults().setTtl(ttlMs);
            fs.setAttribute(path, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String convertMsToDate(long millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS");
        return formatter.format(new Date(millis));
    }

    public static void setPinned(FileSystem fs, AlluxioURI path, boolean pinned) throws IOException {
        try {
            SetAttributeOptions options = SetAttributeOptions.defaults().setPinned(pinned);
            fs.setAttribute(path, options);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }
}

