/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.shell.AlluxioShellUtils;
import alluxio.shell.command.AbstractShellCommand;
import com.google.common.base.Joiner;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CopyToLocalCommand
extends AbstractShellCommand {
    public CopyToLocalCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "copyToLocal";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI srcPath = new AlluxioURI(args[0]);
        File dstFile = new File(args[1]);
        List<AlluxioURI> srcPaths = AlluxioShellUtils.getAlluxioURIs(this.mFileSystem, srcPath);
        if (srcPaths.size() == 0) {
            throw new IOException(srcPath.getPath() + " does not exist.");
        }
        if (srcPath.containsWildcard()) {
            this.copyWildcardToLocal(srcPaths, dstFile);
        } else {
            this.copyToLocal(srcPath, dstFile);
        }
    }

    private void copyWildcardToLocal(List<AlluxioURI> srcPaths, File dstFile) throws IOException {
        if (dstFile.exists() && !dstFile.isDirectory()) {
            throw new IOException(ExceptionMessage.DESTINATION_FILE_CANNOT_EXIST_WITH_WILDCARD_SOURCE.getMessage(new Object[0]));
        }
        if (!dstFile.exists()) {
            if (!dstFile.mkdirs()) {
                throw new IOException("Fail to create directory: " + dstFile.getPath());
            }
            System.out.println("Create directory: " + dstFile.getPath());
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (AlluxioURI srcPath : srcPaths) {
            try {
                this.copyToLocal(srcPath, new File(dstFile.getAbsoluteFile(), srcPath.getName()));
            }
            catch (IOException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.size() != 0) {
            throw new IOException(Joiner.on((char)'\n').join(errorMessages));
        }
    }

    private void copyToLocal(AlluxioURI srcPath, File dstFile) throws IOException {
        URIStatus srcStatus;
        try {
            srcStatus = this.mFileSystem.getStatus(srcPath);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        if (srcStatus.isFolder()) {
            if (!dstFile.exists()) {
                if (!dstFile.mkdirs()) {
                    throw new IOException("mkdir failure for directory: " + dstFile.getAbsolutePath());
                }
                System.out.println("Create directory: " + dstFile.getAbsolutePath());
            }
            List statuses = null;
            try {
                statuses = this.mFileSystem.listStatus(srcPath);
            }
            catch (AlluxioException e) {
                throw new IOException(e.getMessage());
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (URIStatus status : statuses) {
                try {
                    this.copyToLocal(new AlluxioURI(srcPath.getScheme(), srcPath.getAuthority(), status.getPath()), new File(dstFile.getAbsolutePath(), status.getName()));
                }
                catch (IOException e) {
                    errorMessages.add(e.getMessage());
                }
            }
            if (errorMessages.size() != 0) {
                throw new IOException(Joiner.on((char)'\n').join(errorMessages));
            }
        } else {
            this.copyFileToLocal(srcPath, dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToLocal(AlluxioURI srcPath, File dstFile) throws IOException {
        try {
            File tmpDst = File.createTempFile("copyToLocal", null);
            tmpDst.deleteOnExit();
            try (Closer closer = Closer.create();){
                OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
                FileInStream is = (FileInStream)closer.register((Closeable)this.mFileSystem.openFile(srcPath, options));
                FileOutputStream out = (FileOutputStream)closer.register((Closeable)new FileOutputStream(tmpDst));
                byte[] buf = new byte[0x4000000];
                int t = is.read(buf);
                while (t != -1) {
                    out.write(buf, 0, t);
                    t = is.read(buf);
                }
                if (!tmpDst.renameTo(dstFile)) {
                    throw new IOException("Failed to rename " + tmpDst.getPath() + " to destination " + dstFile.getPath());
                }
                System.out.println("Copied " + srcPath + " to " + dstFile.getPath());
            }
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "copyToLocal <src> <localDst>";
    }

    @Override
    public String getDescription() {
        return "Copies a file or a directory from the Alluxio filesystem to the local filesystem.";
    }
}

