/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.Configuration;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class GetUsedBytesCommand
extends AbstractShellCommand {
    public GetUsedBytesCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "getUsedBytes";
    }

    @Override
    protected int getNumOfArgs() {
        return 0;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        long usedBytes = AlluxioBlockStore.get().getUsedBytes();
        System.out.println("Used Bytes: " + usedBytes);
    }

    @Override
    public String getUsage() {
        return "getUsedBytes";
    }

    @Override
    public String getDescription() {
        return "Gets number of bytes used in the Alluxio file system.";
    }
}

