/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.lineage.AlluxioLineage;
import alluxio.shell.command.AbstractShellCommand;
import alluxio.wire.LineageInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class ListLineagesCommand
extends AbstractShellCommand {
    public ListLineagesCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "listLineages";
    }

    @Override
    protected int getNumOfArgs() {
        return 0;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        AlluxioLineage tl = AlluxioLineage.get();
        List infos = tl.getLineageInfoList();
        for (LineageInfo info : infos) {
            System.out.println(info);
        }
    }

    @Override
    public String getUsage() {
        return "listLineages";
    }

    @Override
    public String getDescription() {
        return "Lists all lineages.";
    }
}

