/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.CreateDirectoryOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class MkdirCommand
extends AbstractShellCommand {
    public MkdirCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "mkdir";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args;
        for (String path : args = cl.getArgs()) {
            AlluxioURI inputPath = new AlluxioURI(path);
            try {
                CreateDirectoryOptions options = CreateDirectoryOptions.defaults().setRecursive(true);
                this.mFileSystem.createDirectory(inputPath, options);
                System.out.println("Successfully created directory " + inputPath);
            }
            catch (AlluxioException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public String getUsage() {
        return "mkdir <path1> [path2] ... [pathn]";
    }

    @Override
    public String getDescription() {
        return "Creates the specified directories, including any parent directories that are required.";
    }

    @Override
    public boolean validateArgs(String ... args) {
        boolean valid;
        boolean bl = valid = args.length >= this.getNumOfArgs();
        if (!valid) {
            System.out.println(this.getCommandName() + " takes " + this.getNumOfArgs() + " argument at least\n");
        }
        return valid;
    }
}

