/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ATNType;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.LoopEndState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;

public class ATNSerializer {
    public Grammar g;
    public ATN atn;

    public ATNSerializer(Grammar g, ATN atn) {
        this.g = g;
        this.atn = atn;
    }

    public IntegerList serialize() {
        IntegerList data = new IntegerList();
        data.add(ATNSimulator.SERIALIZED_VERSION);
        this.serializeUUID(data, ATNSimulator.SERIALIZED_UUID);
        switch (this.g.getType()) {
            case 30: {
                data.add(ATNType.LEXER.ordinal());
                break;
            }
            case 43: 
            case 78: {
                data.add(ATNType.PARSER.ordinal());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid grammar type.");
            }
        }
        data.add(this.g.getMaxTokenType());
        int nedges = 0;
        HashMap<IntervalSet, Integer> setIndices = new HashMap<IntervalSet, Integer>();
        ArrayList<IntervalSet> sets = new ArrayList<IntervalSet>();
        IntegerList nonGreedyStates = new IntegerList();
        data.add(this.atn.states.size());
        for (ATNState s : this.atn.states) {
            if (s == null) {
                data.add(0);
                continue;
            }
            int stateType = s.getStateType();
            if (s instanceof DecisionState && ((DecisionState)s).nonGreedy) {
                nonGreedyStates.add(s.stateNumber);
            }
            data.add(stateType);
            if (s.ruleIndex == -1) {
                data.add(65535);
            } else {
                data.add(s.ruleIndex);
            }
            if (s.getStateType() == 12) {
                data.add(((LoopEndState)s).loopBackState.stateNumber);
            } else if (s instanceof BlockStartState) {
                data.add(((BlockStartState)s).endState.stateNumber);
            }
            if (s.getStateType() != 7) {
                nedges += s.getNumberOfTransitions();
            }
            for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
                Transition t = s.transition(i);
                int edgeType = (Integer)Transition.serializationTypes.get(t.getClass());
                if (edgeType != 7 && edgeType != 8) continue;
                SetTransition st = (SetTransition)t;
                if (setIndices.containsKey(st.set)) continue;
                sets.add(st.set);
                setIndices.put(st.set, sets.size() - 1);
            }
        }
        data.add(nonGreedyStates.size());
        for (int i = 0; i < nonGreedyStates.size(); ++i) {
            data.add(nonGreedyStates.get(i));
        }
        int nrules = this.atn.ruleToStartState.length;
        data.add(nrules);
        for (int r = 0; r < nrules; ++r) {
            RuleStartState ruleStartState = this.atn.ruleToStartState[r];
            data.add(ruleStartState.stateNumber);
            if (!this.g.isLexer()) continue;
            if (this.atn.ruleToTokenType[r] == -1) {
                data.add(65535);
            } else {
                data.add(this.atn.ruleToTokenType[r]);
            }
            String ruleName = this.g.rules.getKey(r);
            Rule rule = this.g.getRule(ruleName);
            if (rule.actionIndex == -1) {
                data.add(65535);
                continue;
            }
            data.add(rule.actionIndex);
        }
        int nmodes = this.atn.modeToStartState.size();
        data.add(nmodes);
        if (nmodes > 0) {
            for (ATNState modeStartState : this.atn.modeToStartState) {
                data.add(modeStartState.stateNumber);
            }
        }
        int nsets = sets.size();
        data.add(nsets);
        for (IntervalSet set : sets) {
            boolean containsEof = set.contains(-1);
            if (containsEof && ((Interval)set.getIntervals().get((int)0)).b == -1) {
                data.add(set.getIntervals().size() - 1);
            } else {
                data.add(set.getIntervals().size());
            }
            data.add(containsEof ? 1 : 0);
            for (Interval I : set.getIntervals()) {
                if (I.a == -1) {
                    if (I.b == -1) continue;
                    data.add(0);
                } else {
                    data.add(I.a);
                }
                data.add(I.b);
            }
        }
        data.add(nedges);
        for (ATNState s : this.atn.states) {
            if (s == null || s.getStateType() == 7) continue;
            for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
                Transition t = s.transition(i);
                if (this.atn.states.get(t.target.stateNumber) == null) {
                    throw new IllegalStateException("Cannot serialize a transition to a removed state.");
                }
                int src = s.stateNumber;
                int trg = t.target.stateNumber;
                int edgeType = (Integer)Transition.serializationTypes.get(t.getClass());
                int arg1 = 0;
                int arg2 = 0;
                int arg3 = 0;
                switch (edgeType) {
                    case 3: {
                        trg = ((RuleTransition)t).followState.stateNumber;
                        arg1 = ((RuleTransition)t).target.stateNumber;
                        arg2 = ((RuleTransition)t).ruleIndex;
                        break;
                    }
                    case 4: {
                        PredicateTransition pt = (PredicateTransition)t;
                        arg1 = pt.ruleIndex;
                        arg2 = pt.predIndex;
                        arg3 = pt.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 2: {
                        arg1 = ((RangeTransition)t).from;
                        arg2 = ((RangeTransition)t).to;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 5: {
                        arg1 = ((AtomTransition)t).label;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 6: {
                        ActionTransition at = (ActionTransition)t;
                        arg1 = at.ruleIndex;
                        arg2 = at.actionIndex;
                        if (arg2 == -1) {
                            arg2 = 65535;
                        }
                        arg3 = at.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 7: {
                        arg1 = (Integer)setIndices.get(((SetTransition)t).set);
                        break;
                    }
                    case 8: {
                        arg1 = (Integer)setIndices.get(((SetTransition)t).set);
                        break;
                    }
                }
                data.add(src);
                data.add(trg);
                data.add(edgeType);
                data.add(arg1);
                data.add(arg2);
                data.add(arg3);
            }
        }
        int ndecisions = this.atn.decisionToState.size();
        data.add(ndecisions);
        for (DecisionState decStartState : this.atn.decisionToState) {
            data.add(decStartState.stateNumber);
        }
        for (int i = 1; i < data.size(); ++i) {
            if (data.get(i) < 0 || data.get(i) > 65535) {
                throw new UnsupportedOperationException("Serialized ATN data element out of range.");
            }
            int value = data.get(i) + 2 & 0xFFFF;
            data.set(i, value);
        }
        return data;
    }

    public String decode(char[] data) {
        int version;
        data = (char[])data.clone();
        for (int i = 1; i < data.length; ++i) {
            data[i] = (char)(data[i] - 2);
        }
        StringBuilder buf = new StringBuilder();
        int p = 0;
        if ((version = ATNSimulator.toInt((char)data[p++])) != ATNSimulator.SERIALIZED_VERSION) {
            String reason = String.format("Could not deserialize ATN with version %d (expected %d).", version, ATNSimulator.SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        UUID uuid = ATNSimulator.toUUID((char[])data, (int)p);
        p += 8;
        if (!uuid.equals(ATNSimulator.SERIALIZED_UUID)) {
            String reason = String.format(Locale.getDefault(), "Could not deserialize ATN with UUID %s (expected %s).", uuid, ATNSimulator.SERIALIZED_UUID);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        int grammarType = ATNSimulator.toInt((char)data[p++]);
        int maxType = ATNSimulator.toInt((char)data[p++]);
        buf.append("max type ").append(maxType).append("\n");
        int nstates = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < nstates; ++i) {
            int ruleIndex;
            int stype;
            if ((stype = ATNSimulator.toInt((char)data[p++])) == 0) continue;
            if ((ruleIndex = ATNSimulator.toInt((char)data[p++])) == 65535) {
                ruleIndex = -1;
            }
            String arg = "";
            if (stype == 12) {
                int loopBackStateNumber = ATNSimulator.toInt((char)data[p++]);
                arg = " " + loopBackStateNumber;
            } else if (stype == 4 || stype == 5 || stype == 3) {
                int endStateNumber = ATNSimulator.toInt((char)data[p++]);
                arg = " " + endStateNumber;
            }
            buf.append(i).append(":").append((String)ATNState.serializationNames.get(stype)).append(" ").append(ruleIndex).append(arg).append("\n");
        }
        int numNonGreedyStates = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < numNonGreedyStates; ++i) {
            int stateNumber = ATNSimulator.toInt((char)data[p++]);
        }
        int nrules = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < nrules; ++i) {
            int s = ATNSimulator.toInt((char)data[p++]);
            if (this.g.isLexer()) {
                int arg2;
                int arg1 = ATNSimulator.toInt((char)data[p++]);
                if ((arg2 = ATNSimulator.toInt((char)data[p++])) == 65535) {
                    arg2 = -1;
                }
                buf.append("rule ").append(i).append(":").append(s).append(" ").append(arg1).append(",").append(arg2).append('\n');
                continue;
            }
            buf.append("rule ").append(i).append(":").append(s).append('\n');
        }
        int nmodes = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < nmodes; ++i) {
            int s = ATNSimulator.toInt((char)data[p++]);
            buf.append("mode ").append(i).append(":").append(s).append('\n');
        }
        int nsets = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < nsets; ++i) {
            boolean containsEof;
            int nintervals = ATNSimulator.toInt((char)data[p++]);
            buf.append(i).append(":");
            boolean bl = containsEof = data[p++] != '\u0000';
            if (containsEof) {
                buf.append(this.getTokenName(-1));
            }
            for (int j = 0; j < nintervals; ++j) {
                if (containsEof || j > 0) {
                    buf.append(", ");
                }
                buf.append(this.getTokenName(ATNSimulator.toInt((char)data[p]))).append("..").append(this.getTokenName(ATNSimulator.toInt((char)data[p + 1])));
                p += 2;
            }
            buf.append("\n");
        }
        int nedges = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < nedges; ++i) {
            int src = ATNSimulator.toInt((char)data[p]);
            int trg = ATNSimulator.toInt((char)data[p + 1]);
            int ttype = ATNSimulator.toInt((char)data[p + 2]);
            int arg1 = ATNSimulator.toInt((char)data[p + 3]);
            int arg2 = ATNSimulator.toInt((char)data[p + 4]);
            int arg3 = ATNSimulator.toInt((char)data[p + 5]);
            buf.append(src).append("->").append(trg).append(" ").append((String)Transition.serializationNames.get(ttype)).append(" ").append(arg1).append(",").append(arg2).append(",").append(arg3).append("\n");
            p += 6;
        }
        int ndecisions = ATNSimulator.toInt((char)data[p++]);
        for (int i = 0; i < ndecisions; ++i) {
            int s = ATNSimulator.toInt((char)data[p++]);
            buf.append(i).append(":").append(s).append("\n");
        }
        return buf.toString();
    }

    public String getTokenName(int t) {
        if (t == -1) {
            return "EOF";
        }
        if (this.g != null) {
            return this.g.getTokenDisplayName(t);
        }
        return String.valueOf(t);
    }

    public static String getSerializedAsString(Grammar g, ATN atn) {
        return new String(ATNSerializer.getSerializedAsChars(g, atn));
    }

    public static IntegerList getSerialized(Grammar g, ATN atn) {
        return new ATNSerializer(g, atn).serialize();
    }

    public static char[] getSerializedAsChars(Grammar g, ATN atn) {
        return Utils.toCharArray(ATNSerializer.getSerialized(g, atn));
    }

    public static String getDecoded(Grammar g, ATN atn) {
        IntegerList serialized = ATNSerializer.getSerialized(g, atn);
        char[] data = Utils.toCharArray(serialized);
        return new ATNSerializer(g, atn).decode(data);
    }

    private void serializeUUID(IntegerList data, UUID uuid) {
        this.serializeLong(data, uuid.getLeastSignificantBits());
        this.serializeLong(data, uuid.getMostSignificantBits());
    }

    private void serializeLong(IntegerList data, long value) {
        this.serializeInt(data, (int)value);
        this.serializeInt(data, (int)(value >> 32));
    }

    private void serializeInt(IntegerList data, int value) {
        data.add((int)((char)value));
        data.add((int)((char)(value >> 16)));
    }
}

