/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.antlr.runtime.tree.TreeWizard;
import org.antlr.v4.Tool;
import org.antlr.v4.misc.CharSupport;
import org.antlr.v4.misc.OrderedHashMap;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.parse.ANTLRParser;
import org.antlr.v4.parse.GrammarASTAdaptor;
import org.antlr.v4.parse.GrammarTreeVisitor;
import org.antlr.v4.parse.TokenVocabParser;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.tool.ANTLRToolListener;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.AttributeDict;
import org.antlr.v4.tool.AttributeResolver;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarASTWithOptions;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.antlr.v4.tool.ast.PredAST;
import org.antlr.v4.tool.ast.TerminalAST;

public class Grammar
implements AttributeResolver {
    public static final String GRAMMAR_FROM_STRING_NAME = "<string>";
    public static final Set<String> parserOptions = new HashSet<String>();
    public static final Set<String> lexerOptions;
    public static final Set<String> ruleOptions;
    public static final Set<String> ParserBlockOptions;
    public static final Set<String> LexerBlockOptions;
    public static final Set<String> tokenOptions;
    public static final Set<String> actionOptions;
    public static final Set<String> semPredOptions;
    public static final Set<String> doNotCopyOptionsToLexer;
    public static final Map<String, AttributeDict> grammarAndLabelRefTypeToScope;
    public String name;
    public GrammarRootAST ast;
    @NotNull
    public final TokenStream tokenStream;
    public String text;
    public String fileName;
    public LexerGrammar implicitLexer;
    public Grammar originalGrammar;
    public Grammar parent;
    public List<Grammar> importedGrammars;
    public OrderedHashMap<String, Rule> rules = new OrderedHashMap();
    public List<Rule> indexToRule = new ArrayList<Rule>();
    int ruleNumber = 0;
    int stringLiteralRuleNumber = 0;
    public ATN atn;
    public Map<Integer, DFA> decisionDFAs = new HashMap<Integer, DFA>();
    public List<IntervalSet[]> decisionLOOK;
    @NotNull
    public final Tool tool;
    int maxTokenType = 0;
    public Map<String, Integer> tokenNameToTypeMap = new LinkedHashMap<String, Integer>();
    public Map<String, Integer> stringLiteralToTypeMap = new LinkedHashMap<String, Integer>();
    public List<String> typeToStringLiteralList = new ArrayList<String>();
    public List<String> typeToTokenList = new ArrayList<String>();
    public Map<String, ActionAST> namedActions = new HashMap<String, ActionAST>();
    public LinkedHashMap<ActionAST, Integer> lexerActions = new LinkedHashMap();
    public LinkedHashMap<PredAST, Integer> sempreds = new LinkedHashMap();
    public static final String AUTO_GENERATED_TOKEN_NAME_PREFIX = "T__";

    public Grammar(Tool tool, @NotNull GrammarRootAST ast) {
        if (ast == null) {
            throw new NullPointerException("ast");
        }
        if (ast.tokenStream == null) {
            throw new IllegalArgumentException("ast must have a token stream");
        }
        this.tool = tool;
        this.ast = ast;
        this.name = ast.getChild(0).getText();
        this.tokenStream = ast.tokenStream;
        this.initTokenSymbolTables();
    }

    public Grammar(String grammarText) throws RecognitionException {
        this(GRAMMAR_FROM_STRING_NAME, grammarText, null);
    }

    public Grammar(String grammarText, ANTLRToolListener listener) throws RecognitionException {
        this(GRAMMAR_FROM_STRING_NAME, grammarText, listener);
    }

    public Grammar(String fileName, String grammarText) throws RecognitionException {
        this(fileName, grammarText, null);
    }

    public Grammar(String fileName, String grammarText, @Nullable ANTLRToolListener listener) throws RecognitionException {
        this.text = grammarText;
        this.fileName = fileName;
        this.tool = new Tool();
        this.tool.addListener(listener);
        ANTLRStringStream in = new ANTLRStringStream(grammarText);
        in.name = fileName;
        this.ast = this.tool.load(fileName, (CharStream)in);
        if (this.ast == null) {
            throw new UnsupportedOperationException();
        }
        if (this.ast.tokenStream == null) {
            throw new IllegalStateException("expected ast to have a token stream");
        }
        this.tokenStream = this.ast.tokenStream;
        final Grammar thiz = this;
        TreeVisitor v = new TreeVisitor((TreeAdaptor)new GrammarASTAdaptor());
        v.visit((Object)this.ast, new TreeVisitorAction(){

            public Object pre(Object t) {
                ((GrammarAST)((Object)t)).g = thiz;
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        });
        this.initTokenSymbolTables();
        this.tool.process(this, false);
    }

    protected void initTokenSymbolTables() {
        this.tokenNameToTypeMap.put("EOF", -1);
        this.typeToTokenList.add(null);
    }

    public void loadImportedGrammars() {
        if (this.ast == null) {
            return;
        }
        GrammarAST i = (GrammarAST)this.ast.getFirstChildWithType(28);
        if (i == null) {
            return;
        }
        this.importedGrammars = new ArrayList<Grammar>();
        for (Object c : i.getChildren()) {
            Grammar g;
            GrammarAST t = (GrammarAST)((Object)c);
            String importedGrammarName = null;
            if (t.getType() == 10) {
                importedGrammarName = t.getChild(1).getText();
                this.tool.log("grammar", "import " + importedGrammarName);
            } else if (t.getType() == 27) {
                importedGrammarName = t.getText();
                this.tool.log("grammar", "import " + t.getText());
            }
            try {
                g = this.tool.loadImportedGrammar(this, importedGrammarName);
            }
            catch (IOException ioe) {
                this.tool.errMgr.toolError(ErrorType.CANNOT_FIND_IMPORTED_GRAMMAR, ioe, importedGrammarName);
                continue;
            }
            if (g == null) continue;
            g.parent = this;
            this.importedGrammars.add(g);
            g.loadImportedGrammars();
        }
    }

    public void defineAction(GrammarAST atAST) {
        if (atAST.getChildCount() == 2) {
            String name = atAST.getChild(0).getText();
            this.namedActions.put(name, (ActionAST)atAST.getChild(1));
        } else {
            String gtype;
            String scope = atAST.getChild(0).getText();
            if (scope.equals(gtype = this.getTypeString()) || scope.equals("parser") && gtype.equals("combined")) {
                String name = atAST.getChild(1).getText();
                this.namedActions.put(name, (ActionAST)atAST.getChild(2));
            }
        }
    }

    public void defineRule(Rule r) {
        if (this.rules.get(r.name) != null) {
            return;
        }
        this.rules.put(r.name, r);
        r.index = this.ruleNumber++;
        this.indexToRule.add(r);
    }

    public Rule getRule(String name) {
        Rule r = (Rule)this.rules.get(name);
        if (r != null) {
            return r;
        }
        return null;
    }

    public Rule getRule(int index) {
        return this.indexToRule.get(index);
    }

    public Rule getRule(String grammarName, String ruleName) {
        if (grammarName != null) {
            Grammar g = this.getImportedGrammar(grammarName);
            if (g == null) {
                return null;
            }
            return (Rule)g.rules.get(ruleName);
        }
        return this.getRule(ruleName);
    }

    public List<Grammar> getAllImportedGrammars() {
        if (this.importedGrammars == null) {
            return null;
        }
        ArrayList<Grammar> delegates = new ArrayList<Grammar>();
        for (Grammar d : this.importedGrammars) {
            delegates.add(d);
            List<Grammar> ds = d.getAllImportedGrammars();
            if (ds == null) continue;
            delegates.addAll(ds);
        }
        return delegates;
    }

    public List<Grammar> getImportedGrammars() {
        return this.importedGrammars;
    }

    public List<Grammar> getGrammarAncestors() {
        Grammar root = this.getOutermostGrammar();
        if (this == root) {
            return null;
        }
        ArrayList<Grammar> grammars = new ArrayList<Grammar>();
        Grammar p = this.parent;
        while (p != null) {
            grammars.add(0, p);
            p = p.parent;
        }
        return grammars;
    }

    public Grammar getOutermostGrammar() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getOutermostGrammar();
    }

    public String getRecognizerName() {
        String suffix = "";
        List<Grammar> grammarsFromRootToMe = this.getOutermostGrammar().getGrammarAncestors();
        String qualifiedName = this.name;
        if (grammarsFromRootToMe != null) {
            StringBuilder buf = new StringBuilder();
            for (Grammar g : grammarsFromRootToMe) {
                buf.append(g.name);
                buf.append('_');
            }
            buf.append(this.name);
            qualifiedName = buf.toString();
        }
        if (this.isCombined() || this.isLexer() && this.implicitLexer != null) {
            suffix = Grammar.getGrammarTypeToFileNameSuffix(this.getType());
        }
        return qualifiedName + suffix;
    }

    public String getStringLiteralLexerRuleName(String lit) {
        return AUTO_GENERATED_TOKEN_NAME_PREFIX + this.stringLiteralRuleNumber++;
    }

    public Grammar getImportedGrammar(String name) {
        for (Grammar g : this.importedGrammars) {
            if (!g.name.equals(name)) continue;
            return g;
        }
        return null;
    }

    public int getTokenType(String token) {
        Integer I = token.charAt(0) == '\'' ? this.stringLiteralToTypeMap.get(token) : this.tokenNameToTypeMap.get(token);
        int i = I != null ? I : 0;
        return i;
    }

    public String getTokenDisplayName(int ttype) {
        String tokenName;
        if (this.isLexer() && ttype >= 0 && ttype <= 65534) {
            return CharSupport.getANTLRCharLiteralForChar(ttype);
        }
        if (ttype == -1) {
            tokenName = "EOF";
        } else if (ttype > 0 && ttype < this.typeToTokenList.size()) {
            tokenName = this.typeToTokenList.get(ttype);
            if (tokenName != null && tokenName.startsWith(AUTO_GENERATED_TOKEN_NAME_PREFIX) && ttype < this.typeToStringLiteralList.size() && this.typeToStringLiteralList.get(ttype) != null) {
                tokenName = this.typeToStringLiteralList.get(ttype);
            }
        } else {
            tokenName = String.valueOf(ttype);
        }
        return tokenName;
    }

    public List<String> getTokenDisplayNames(IntegerList types) {
        ArrayList<String> names = new ArrayList<String>();
        for (int t : types.toArray()) {
            names.add(this.getTokenDisplayName(t));
        }
        return names;
    }

    public String[] getTokenNames() {
        int numTokens = this.getMaxTokenType();
        String[] tokenNames = new String[numTokens + 1];
        for (String tokenName : this.tokenNameToTypeMap.keySet()) {
            Integer ttype = this.tokenNameToTypeMap.get(tokenName);
            if (tokenName != null && tokenName.startsWith(AUTO_GENERATED_TOKEN_NAME_PREFIX)) {
                tokenName = this.typeToStringLiteralList.get(ttype);
            }
            if (ttype <= 0) continue;
            tokenNames[ttype.intValue()] = tokenName;
        }
        return tokenNames;
    }

    public String[] getTokenDisplayNames() {
        Integer ttype;
        int numTokens = this.getMaxTokenType();
        String[] tokenNames = new String[numTokens + 1];
        for (String t : this.tokenNameToTypeMap.keySet()) {
            ttype = this.tokenNameToTypeMap.get(t);
            if (ttype <= 0) continue;
            tokenNames[ttype.intValue()] = t;
        }
        for (String t : this.stringLiteralToTypeMap.keySet()) {
            ttype = this.stringLiteralToTypeMap.get(t);
            if (ttype <= 0) continue;
            tokenNames[ttype.intValue()] = t;
        }
        return tokenNames;
    }

    public int getMaxCharValue() {
        return 65534;
    }

    public IntSet getTokenTypes() {
        if (this.isLexer()) {
            return this.getAllCharValues();
        }
        return IntervalSet.of((int)1, (int)this.getMaxTokenType());
    }

    public IntSet getAllCharValues() {
        return IntervalSet.of((int)0, (int)this.getMaxCharValue());
    }

    public int getMaxTokenType() {
        return this.typeToTokenList.size() - 1;
    }

    public int getNewTokenType() {
        ++this.maxTokenType;
        return this.maxTokenType;
    }

    public void importTokensFromTokensFile() {
        String vocab = this.getOptionString("tokenVocab");
        if (vocab != null) {
            TokenVocabParser vparser = new TokenVocabParser(this.tool, vocab);
            Map<String, Integer> tokens = vparser.load();
            this.tool.log("grammar", "tokens=" + tokens);
            for (String t : tokens.keySet()) {
                if (t.charAt(0) == '\'') {
                    this.defineStringLiteral(t, tokens.get(t));
                    continue;
                }
                this.defineTokenName(t, tokens.get(t));
            }
        }
    }

    public void importVocab(Grammar importG) {
        for (String tokenName : importG.tokenNameToTypeMap.keySet()) {
            this.defineTokenName(tokenName, importG.tokenNameToTypeMap.get(tokenName));
        }
        for (String tokenName : importG.stringLiteralToTypeMap.keySet()) {
            this.defineStringLiteral(tokenName, importG.stringLiteralToTypeMap.get(tokenName));
        }
        int max = Math.max(this.typeToTokenList.size(), importG.typeToTokenList.size());
        Utils.setSize(this.typeToTokenList, max);
        for (int ttype = 0; ttype < importG.typeToTokenList.size(); ++ttype) {
            this.maxTokenType = Math.max(this.maxTokenType, ttype);
            this.typeToTokenList.set(ttype, importG.typeToTokenList.get(ttype));
        }
    }

    public int defineTokenName(String name) {
        Integer prev = this.tokenNameToTypeMap.get(name);
        if (prev == null) {
            return this.defineTokenName(name, this.getNewTokenType());
        }
        return prev;
    }

    public int defineTokenName(String name, int ttype) {
        Integer prev = this.tokenNameToTypeMap.get(name);
        if (prev != null) {
            return prev;
        }
        this.tokenNameToTypeMap.put(name, ttype);
        this.setTokenForType(ttype, name);
        this.maxTokenType = Math.max(this.maxTokenType, ttype);
        return ttype;
    }

    public int defineStringLiteral(String lit) {
        if (this.stringLiteralToTypeMap.containsKey(lit)) {
            return this.stringLiteralToTypeMap.get(lit);
        }
        return this.defineStringLiteral(lit, this.getNewTokenType());
    }

    public int defineStringLiteral(String lit, int ttype) {
        if (!this.stringLiteralToTypeMap.containsKey(lit)) {
            this.stringLiteralToTypeMap.put(lit, ttype);
            if (ttype >= this.typeToStringLiteralList.size()) {
                Utils.setSize(this.typeToStringLiteralList, ttype + 1);
            }
            this.typeToStringLiteralList.set(ttype, lit);
            this.setTokenForType(ttype, lit);
            return ttype;
        }
        return 0;
    }

    public int defineTokenAlias(String name, String lit) {
        int ttype = this.defineTokenName(name);
        this.stringLiteralToTypeMap.put(lit, ttype);
        this.setTokenForType(ttype, name);
        return ttype;
    }

    public void setTokenForType(int ttype, String text) {
        String prevToken;
        if (ttype >= this.typeToTokenList.size()) {
            Utils.setSize(this.typeToTokenList, ttype + 1);
        }
        if ((prevToken = this.typeToTokenList.get(ttype)) == null || prevToken.charAt(0) == '\'') {
            this.typeToTokenList.set(ttype, text);
        }
    }

    @Override
    public Attribute resolveToAttribute(String x, ActionAST node) {
        return null;
    }

    @Override
    public Attribute resolveToAttribute(String x, String y, ActionAST node) {
        return null;
    }

    @Override
    public boolean resolvesToLabel(String x, ActionAST node) {
        return false;
    }

    @Override
    public boolean resolvesToListLabel(String x, ActionAST node) {
        return false;
    }

    @Override
    public boolean resolvesToToken(String x, ActionAST node) {
        return false;
    }

    @Override
    public boolean resolvesToAttributeDict(String x, ActionAST node) {
        return false;
    }

    public String getDefaultActionScope() {
        switch (this.getType()) {
            case 30: {
                return "lexer";
            }
            case 43: 
            case 78: {
                return "parser";
            }
        }
        return null;
    }

    public int getType() {
        if (this.ast != null) {
            return this.ast.grammarType;
        }
        return 0;
    }

    public TokenStream getTokenStream() {
        if (this.ast != null) {
            return this.ast.tokenStream;
        }
        return null;
    }

    public boolean isLexer() {
        return this.getType() == 30;
    }

    public boolean isParser() {
        return this.getType() == 43;
    }

    public boolean isCombined() {
        return this.getType() == 78;
    }

    public static boolean isTokenName(String id) {
        return Character.isUpperCase(id.charAt(0));
    }

    public String getTypeString() {
        if (this.ast == null) {
            return null;
        }
        return ANTLRParser.tokenNames[this.getType()].toLowerCase();
    }

    public static String getGrammarTypeToFileNameSuffix(int type) {
        switch (type) {
            case 30: {
                return "Lexer";
            }
            case 43: {
                return "Parser";
            }
            case 78: {
                return "Parser";
            }
        }
        return "<invalid>";
    }

    public String getOptionString(String key) {
        return this.ast.getOptionString(key);
    }

    public static void setNodeOptions(GrammarAST node, GrammarAST options) {
        GrammarASTWithOptions t = (GrammarASTWithOptions)node;
        if (t.getChildCount() == 0 || options.getChildCount() == 0) {
            return;
        }
        for (Object o : options.getChildren()) {
            GrammarAST c = (GrammarAST)((Object)o);
            if (c.getType() == 10) {
                t.setOption(c.getChild(0).getText(), (GrammarAST)c.getChild(1));
                continue;
            }
            t.setOption(c.getText(), null);
        }
    }

    public static List<Pair<GrammarAST, GrammarAST>> getStringLiteralAliasesFromLexerRules(GrammarRootAST ast) {
        String[] patterns = new String[]{"(RULE %name:TOKEN_REF (BLOCK (ALT %lit:STRING_LITERAL)))", "(RULE %name:TOKEN_REF (BLOCK (ALT %lit:STRING_LITERAL ACTION)))", "(RULE %name:TOKEN_REF (BLOCK (ALT %lit:STRING_LITERAL SEMPRED)))", "(RULE %name:TOKEN_REF (BLOCK (LEXER_ALT_ACTION (ALT %lit:STRING_LITERAL) .)))", "(RULE %name:TOKEN_REF (BLOCK (LEXER_ALT_ACTION (ALT %lit:STRING_LITERAL) . .)))", "(RULE %name:TOKEN_REF (BLOCK (LEXER_ALT_ACTION (ALT %lit:STRING_LITERAL) (LEXER_ACTION_CALL . .))))", "(RULE %name:TOKEN_REF (BLOCK (LEXER_ALT_ACTION (ALT %lit:STRING_LITERAL) . (LEXER_ACTION_CALL . .))))", "(RULE %name:TOKEN_REF (BLOCK (LEXER_ALT_ACTION (ALT %lit:STRING_LITERAL) (LEXER_ACTION_CALL . .) .)))"};
        GrammarASTAdaptor adaptor = new GrammarASTAdaptor(ast.token.getInputStream());
        TreeWizard wiz = new TreeWizard((TreeAdaptor)adaptor, ANTLRParser.tokenNames);
        ArrayList<Pair<GrammarAST, GrammarAST>> lexerRuleToStringLiteral = new ArrayList<Pair<GrammarAST, GrammarAST>>();
        List<GrammarAST> ruleNodes = ast.getNodesWithType(91);
        if (ruleNodes == null || ruleNodes.isEmpty()) {
            return null;
        }
        for (GrammarAST r : ruleNodes) {
            String pattern;
            boolean isLitRule;
            Tree name = r.getChild(0);
            if (name.getType() != 65) continue;
            String[] arr$ = patterns;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(isLitRule = Grammar.defAlias(r, pattern = arr$[i$], wiz, lexerRuleToStringLiteral)); ++i$) {
            }
        }
        return lexerRuleToStringLiteral;
    }

    protected static boolean defAlias(GrammarAST r, String pattern, TreeWizard wiz, List<Pair<GrammarAST, GrammarAST>> lexerRuleToStringLiteral) {
        HashMap nodes = new HashMap();
        if (wiz.parse((Object)r, pattern, nodes)) {
            GrammarAST litNode = (GrammarAST)((Object)nodes.get("lit"));
            GrammarAST nameNode = (GrammarAST)((Object)nodes.get("name"));
            Pair pair = new Pair((Object)nameNode, (Object)litNode);
            lexerRuleToStringLiteral.add((Pair<GrammarAST, GrammarAST>)pair);
            return true;
        }
        return false;
    }

    public Set<String> getStringLiterals() {
        final HashSet<String> strings = new HashSet<String>();
        GrammarTreeVisitor collector = new GrammarTreeVisitor(){

            @Override
            public void stringRef(TerminalAST ref) {
                strings.add(ref.getText());
            }
        };
        collector.visitGrammar(this.ast);
        return strings;
    }

    public void setLookaheadDFA(int decision, DFA lookaheadDFA) {
        this.decisionDFAs.put(decision, lookaheadDFA);
    }

    static {
        parserOptions.add("superClass");
        parserOptions.add("TokenLabelType");
        parserOptions.add("tokenVocab");
        parserOptions.add("language");
        lexerOptions = parserOptions;
        ruleOptions = new HashSet<String>();
        ParserBlockOptions = new HashSet<String>();
        LexerBlockOptions = new HashSet<String>();
        tokenOptions = new HashSet<String>();
        tokenOptions.add("assoc");
        actionOptions = new HashSet<String>();
        semPredOptions = new HashSet<String>();
        semPredOptions.add("fail");
        doNotCopyOptionsToLexer = new HashSet<String>();
        doNotCopyOptionsToLexer.add("superClass");
        doNotCopyOptionsToLexer.add("TokenLabelType");
        doNotCopyOptionsToLexer.add("tokenVocab");
        grammarAndLabelRefTypeToScope = new HashMap<String, AttributeDict>();
        grammarAndLabelRefTypeToScope.put("parser:RULE_LABEL", Rule.predefinedRulePropertiesDict);
        grammarAndLabelRefTypeToScope.put("parser:TOKEN_LABEL", AttributeDict.predefinedTokenDict);
        grammarAndLabelRefTypeToScope.put("combined:RULE_LABEL", Rule.predefinedRulePropertiesDict);
        grammarAndLabelRefTypeToScope.put("combined:TOKEN_LABEL", AttributeDict.predefinedTokenDict);
    }
}

