/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.common.parameters;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.amber.oauth2.common.message.OAuthMessage;
import org.apache.amber.oauth2.common.parameters.OAuthParametersApplier;
import org.apache.amber.oauth2.common.utils.OAuthUtils;

public class QueryParameterApplier
implements OAuthParametersApplier {
    @Override
    public OAuthMessage applyOAuthParameters(OAuthMessage message, Map<String, Object> params) {
        String messageUrl = message.getLocationUri();
        if (messageUrl != null) {
            boolean containsQuestionMark = messageUrl.contains("?");
            StringBuffer url = new StringBuffer(messageUrl);
            LinkedHashMap<String, Object> fragmentParams = new LinkedHashMap<String, Object>();
            if (params.containsKey("access_token")) {
                fragmentParams.put("access_token", params.remove("access_token"));
                if (params.containsKey("state")) {
                    fragmentParams.put("state", params.remove("state"));
                }
                if (params.containsKey("expires_in")) {
                    fragmentParams.put("expires_in", params.remove("expires_in"));
                }
                if (params.containsKey("token_type")) {
                    fragmentParams.put("token_type", params.remove("token_type"));
                }
            }
            StringBuffer query = new StringBuffer(OAuthUtils.format(params.entrySet(), "UTF-8"));
            String fragmentQuery = "";
            if (fragmentParams.containsKey("access_token")) {
                fragmentQuery = OAuthUtils.format(fragmentParams.entrySet(), "UTF-8");
            }
            if (!OAuthUtils.isEmpty(query.toString())) {
                if (containsQuestionMark) {
                    url.append("&").append(query);
                } else {
                    url.append("?").append(query);
                }
            }
            if (!OAuthUtils.isEmpty(fragmentQuery)) {
                url.append("#").append(fragmentQuery);
            }
            message.setLocationUri(url.toString());
        }
        return message;
    }
}

