/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHttpClientConfig;
import org.apache.apex.shaded.ning19.com.ning.http.util.MiscUtils;
import org.apache.apex.shaded.ning19.com.ning.http.util.SslUtils;

public interface SSLEngineFactory {
    public SSLEngine newSSLEngine(String var1, int var2) throws GeneralSecurityException;

    public static class DefaultSSLEngineFactory
    implements SSLEngineFactory {
        private final AsyncHttpClientConfig config;

        public DefaultSSLEngineFactory(AsyncHttpClientConfig config) {
            this.config = config;
        }

        @Override
        public SSLEngine newSSLEngine(String peerHost, int peerPort) throws GeneralSecurityException {
            SSLContext sslContext = SslUtils.getInstance().getSSLContext(this.config);
            SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
            sslEngine.setUseClientMode(true);
            if (!this.config.isAcceptAnyCertificate()) {
                SSLParameters params = sslEngine.getSSLParameters();
                params.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(params);
            }
            if (MiscUtils.isNonEmpty(this.config.getEnabledProtocols())) {
                sslEngine.setEnabledProtocols(this.config.getEnabledProtocols());
            }
            if (MiscUtils.isNonEmpty(this.config.getEnabledCipherSuites())) {
                sslEngine.setEnabledCipherSuites(this.config.getEnabledCipherSuites());
            }
            return sslEngine;
        }
    }
}

