/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHttpClientConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.channel.ChannelManager;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.ProgressListener;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.NettyBody;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.OptimizedFileRegion;
import org.apache.apex.shaded.ning19.com.ning.http.util.MiscUtils;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFuture;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.stream.ChunkedFile;

public class NettyFileBody
implements NettyBody {
    private final File file;
    private final long offset;
    private final long length;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyFileBody(File file, NettyAsyncHttpProviderConfig nettyConfig) throws IOException {
        this(file, 0L, file.length(), nettyConfig);
    }

    public NettyFileBody(File file, long offset, long length, NettyAsyncHttpProviderConfig nettyConfig) throws IOException {
        if (!file.isFile()) {
            throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.nettyConfig = nettyConfig;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            ChannelFuture writeFuture;
            if (ChannelManager.isSslHandlerConfigured(channel.getPipeline()) || this.nettyConfig.isDisableZeroCopy()) {
                writeFuture = channel.write(new ChunkedFile(raf, this.offset, raf.length(), this.nettyConfig.getChunkedFileChunkSize()));
            } else {
                OptimizedFileRegion region = new OptimizedFileRegion(raf, this.offset, raf.length());
                writeFuture = channel.write(region);
            }
            writeFuture.addListener(new ProgressListener(config, future.getAsyncHandler(), future, false){

                @Override
                public void operationComplete(ChannelFuture cf) {
                    MiscUtils.closeSilently(raf);
                    super.operationComplete(cf);
                }
            });
        }
        catch (IOException ex) {
            MiscUtils.closeSilently(raf);
            throw ex;
        }
    }
}

