
package org.apache.beam.runners.direct;

import java.util.Set;
import javax.annotation.Generated;
import org.apache.beam.sdk.metrics.MetricUpdates;
import org.apache.beam.sdk.transforms.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StepTransformResult<InputT> extends StepTransformResult<InputT> {

  private final AppliedPTransform<?, ?, ?> transform;
  private final Iterable<? extends DirectRunner.UncommittedBundle<?>> outputBundles;
  private final Iterable<? extends WindowedValue<InputT>> unprocessedElements;
  private final AggregatorContainer.Mutator aggregatorChanges;
  private final MetricUpdates logicalMetricUpdates;
  private final Instant watermarkHold;
  private final CopyOnAccessInMemoryStateInternals<?> state;
  private final WatermarkManager.TimerUpdate timerUpdate;
  private final Set<CommittedResult.OutputType> outputTypes;

  AutoValue_StepTransformResult(
      AppliedPTransform<?, ?, ?> transform,
      Iterable<? extends DirectRunner.UncommittedBundle<?>> outputBundles,
      Iterable<? extends WindowedValue<InputT>> unprocessedElements,
      @javax.annotation.Nullable AggregatorContainer.Mutator aggregatorChanges,
      MetricUpdates logicalMetricUpdates,
      Instant watermarkHold,
      @javax.annotation.Nullable CopyOnAccessInMemoryStateInternals<?> state,
      WatermarkManager.TimerUpdate timerUpdate,
      Set<CommittedResult.OutputType> outputTypes) {
    if (transform == null) {
      throw new NullPointerException("Null transform");
    }
    this.transform = transform;
    if (outputBundles == null) {
      throw new NullPointerException("Null outputBundles");
    }
    this.outputBundles = outputBundles;
    if (unprocessedElements == null) {
      throw new NullPointerException("Null unprocessedElements");
    }
    this.unprocessedElements = unprocessedElements;
    this.aggregatorChanges = aggregatorChanges;
    if (logicalMetricUpdates == null) {
      throw new NullPointerException("Null logicalMetricUpdates");
    }
    this.logicalMetricUpdates = logicalMetricUpdates;
    if (watermarkHold == null) {
      throw new NullPointerException("Null watermarkHold");
    }
    this.watermarkHold = watermarkHold;
    this.state = state;
    if (timerUpdate == null) {
      throw new NullPointerException("Null timerUpdate");
    }
    this.timerUpdate = timerUpdate;
    if (outputTypes == null) {
      throw new NullPointerException("Null outputTypes");
    }
    this.outputTypes = outputTypes;
  }

  @Override
  public AppliedPTransform<?, ?, ?> getTransform() {
    return transform;
  }

  @Override
  public Iterable<? extends DirectRunner.UncommittedBundle<?>> getOutputBundles() {
    return outputBundles;
  }

  @Override
  public Iterable<? extends WindowedValue<InputT>> getUnprocessedElements() {
    return unprocessedElements;
  }

  @javax.annotation.Nullable
  @Override
  public AggregatorContainer.Mutator getAggregatorChanges() {
    return aggregatorChanges;
  }

  @Override
  public MetricUpdates getLogicalMetricUpdates() {
    return logicalMetricUpdates;
  }

  @Override
  public Instant getWatermarkHold() {
    return watermarkHold;
  }

  @javax.annotation.Nullable
  @Override
  public CopyOnAccessInMemoryStateInternals<?> getState() {
    return state;
  }

  @Override
  public WatermarkManager.TimerUpdate getTimerUpdate() {
    return timerUpdate;
  }

  @Override
  public Set<CommittedResult.OutputType> getOutputTypes() {
    return outputTypes;
  }

  @Override
  public String toString() {
    return "StepTransformResult{"
        + "transform=" + transform + ", "
        + "outputBundles=" + outputBundles + ", "
        + "unprocessedElements=" + unprocessedElements + ", "
        + "aggregatorChanges=" + aggregatorChanges + ", "
        + "logicalMetricUpdates=" + logicalMetricUpdates + ", "
        + "watermarkHold=" + watermarkHold + ", "
        + "state=" + state + ", "
        + "timerUpdate=" + timerUpdate + ", "
        + "outputTypes=" + outputTypes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StepTransformResult) {
      StepTransformResult<?> that = (StepTransformResult<?>) o;
      return (this.transform.equals(that.getTransform()))
           && (this.outputBundles.equals(that.getOutputBundles()))
           && (this.unprocessedElements.equals(that.getUnprocessedElements()))
           && ((this.aggregatorChanges == null) ? (that.getAggregatorChanges() == null) : this.aggregatorChanges.equals(that.getAggregatorChanges()))
           && (this.logicalMetricUpdates.equals(that.getLogicalMetricUpdates()))
           && (this.watermarkHold.equals(that.getWatermarkHold()))
           && ((this.state == null) ? (that.getState() == null) : this.state.equals(that.getState()))
           && (this.timerUpdate.equals(that.getTimerUpdate()))
           && (this.outputTypes.equals(that.getOutputTypes()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= transform.hashCode();
    h *= 1000003;
    h ^= outputBundles.hashCode();
    h *= 1000003;
    h ^= unprocessedElements.hashCode();
    h *= 1000003;
    h ^= (aggregatorChanges == null) ? 0 : aggregatorChanges.hashCode();
    h *= 1000003;
    h ^= logicalMetricUpdates.hashCode();
    h *= 1000003;
    h ^= watermarkHold.hashCode();
    h *= 1000003;
    h ^= (state == null) ? 0 : state.hashCode();
    h *= 1000003;
    h ^= timerUpdate.hashCode();
    h *= 1000003;
    h ^= outputTypes.hashCode();
    return h;
  }

}
