/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl;

import java.lang.reflect.InvocationHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.data.api.AbstractEntityRepository;
import org.apache.deltaspike.data.api.AbstractFullEntityRepository;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.impl.RepositoryDefinitionException;
import org.apache.deltaspike.data.impl.meta.RepositoryComponents;

public class RepositoryExtension
implements Extension,
Deactivatable {
    private static final Logger log = Logger.getLogger(RepositoryExtension.class.getName());
    private static RepositoryComponents staticComponents = new RepositoryComponents();
    private final List<RepositoryDefinitionException> definitionExceptions = new LinkedList<RepositoryDefinitionException>();
    private Boolean isActivated = true;
    private RepositoryComponents components = new RepositoryComponents();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery before) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.isVetoed(event.getAnnotatedType())) {
            event.veto();
        } else if (this.isRepository(event.getAnnotatedType())) {
            Class repoClass = event.getAnnotatedType().getJavaClass();
            try {
                log.log(Level.FINER, "getHandlerClass: Repository annotation detected on {0}", event.getAnnotatedType());
                if (Deactivatable.class.isAssignableFrom(repoClass) && !ClassDeactivationUtils.isActivated((Class)repoClass)) {
                    log.log(Level.FINER, "Class {0} is Deactivated", repoClass);
                    return;
                }
                this.components.add(repoClass);
                staticComponents.add(repoClass);
            }
            catch (RepositoryDefinitionException e) {
                this.definitionExceptions.add(e);
            }
            catch (Exception e) {
                this.definitionExceptions.add(new RepositoryDefinitionException(repoClass, (Throwable)e));
            }
        }
    }

    <X> void addDefinitionErrors(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (RepositoryDefinitionException ex : this.definitionExceptions) {
            afterBeanDiscovery.addDefinitionError((Throwable)ex);
        }
    }

    private <X> boolean isRepository(AnnotatedType<X> annotatedType) {
        return (annotatedType.isAnnotationPresent(Repository.class) || annotatedType.getJavaClass().isAnnotationPresent(Repository.class)) && !InvocationHandler.class.isAssignableFrom(annotatedType.getJavaClass());
    }

    private <X> boolean isVetoed(AnnotatedType<X> annotated) {
        Class javaClass = annotated.getJavaClass();
        return javaClass.equals(AbstractEntityRepository.class) || javaClass.equals(AbstractFullEntityRepository.class);
    }

    public RepositoryComponents getComponents() {
        RepositoryComponents result = new RepositoryComponents();
        if (this.components.getRepositories().isEmpty() && !staticComponents.getRepositories().isEmpty()) {
            result.addAll(staticComponents.getRepositories());
        }
        if (!this.components.getRepositories().isEmpty()) {
            result.addAll(this.components.getRepositories());
        }
        return result;
    }

    protected void cleanup(@Observes BeforeShutdown beforeShutdown) {
        staticComponents.getRepositories().clear();
    }
}

