/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.data.api.QueryInvocationException;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.MethodType;
import org.apache.deltaspike.data.impl.meta.QueryInvocation;
import org.apache.deltaspike.data.impl.util.bean.BeanDestroyable;
import org.apache.deltaspike.data.spi.DelegateQueryHandler;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

@QueryInvocation(value=MethodType.DELEGATE)
public class DelegateQueryBuilder
extends QueryBuilder {
    @Inject
    private BeanManager beanManager;

    @Override
    public Object execute(CdiQueryInvocationContext context) {
        try {
            DelegateQueryHandler delegate = this.selectDelegate(context);
            if (delegate != null) {
                return this.invoke(delegate, context);
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryInvocationException((Throwable)e, (QueryInvocationContext)context);
        }
        throw new QueryInvocationException("No DelegateQueryHandler found", (QueryInvocationContext)context);
    }

    private DelegateQueryHandler selectDelegate(CdiQueryInvocationContext context) {
        Set beans = BeanProvider.getBeanDefinitions(DelegateQueryHandler.class, (boolean)true, (boolean)true);
        for (Bean bean : beans) {
            if (!ClassUtils.containsMethod((Class)bean.getBeanClass(), (Method)context.getMethod())) continue;
            if (bean.getScope().equals(Dependent.class)) {
                CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
                DelegateQueryHandler instance = (DelegateQueryHandler)this.beanManager.getReference(bean, DelegateQueryHandler.class, cc);
                context.addDestroyable(new BeanDestroyable<DelegateQueryHandler>(bean, instance, cc));
                return instance;
            }
            return (DelegateQueryHandler)BeanProvider.getContextualReference((Class)bean.getBeanClass(), (Annotation[])new Annotation[0]);
        }
        return null;
    }

    private Object invoke(DelegateQueryHandler delegate, CdiQueryInvocationContext context) {
        try {
            return this.invoke(delegate, context.getMethod(), context.getMethodParameters());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof PersistenceException) {
                throw (PersistenceException)e.getCause();
            }
            throw new QueryInvocationException((Throwable)e, (QueryInvocationContext)context);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object invoke(Object target, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Method extract = ClassUtils.extractMethod(target.getClass(), (Method)method);
        return extract.invoke(target, args);
    }
}

