/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.io.Serializable;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.util.EntityUtils;

public class RepositoryEntity {
    private Class<?> entityClass;
    private Class<? extends Serializable> primaryKeyClass;
    private Property<Serializable> primaryKeyProperty;
    private Property<Serializable> versionProperty;
    private String entityName;

    public RepositoryEntity(Class<?> entityClass) {
        this(entityClass, null);
    }

    public RepositoryEntity(Class<?> entityClass, Class<? extends Serializable> primaryClass) {
        this.entityClass = entityClass;
        this.primaryKeyClass = primaryClass;
        this.primaryKeyProperty = EntityUtils.primaryKeyProperty(entityClass);
        this.versionProperty = EntityUtils.getVersionProperty(entityClass);
        this.entityName = EntityUtils.entityName(entityClass);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<? extends Serializable> getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public void setPrimaryKeyClass(Class<? extends Serializable> primaryKeyClass) {
        this.primaryKeyClass = primaryKeyClass;
    }

    public Property<Serializable> getVersionProperty() {
        return this.versionProperty;
    }

    public void setVersionProperty(Property<Serializable> versionProperty) {
        this.versionProperty = versionProperty;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Property<Serializable> getPrimaryKeyProperty() {
        return this.primaryKeyProperty;
    }

    public void setPrimaryKeyProperty(Property<Serializable> primaryKeyProperty) {
        this.primaryKeyProperty = primaryKeyProperty;
    }
}

