/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.compiler.plan.OptimizedPlan;
import org.apache.flink.compiler.plandump.PlanJSONDumpGenerator;

public class ContextEnvironment
extends ExecutionEnvironment {
    private final Client client;
    private final List<File> jarFilesToAttach;
    private final ClassLoader userCodeClassLoader;

    public ContextEnvironment(Client remoteConnection, List<File> jarFiles, ClassLoader userCodeClassLoader) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars((Plan)p, this.jarFilesToAttach, this.userCodeClassLoader);
        return this.client.run(toRun, this.getDegreeOfParallelism(), true);
    }

    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan("unnamed job");
        OptimizedPlan op = this.client.getOptimizedPlan((Plan)p, this.getDegreeOfParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public String toString() {
        return "Context Environment (DOP = " + (this.getDegreeOfParallelism() == -1 ? "default" : Integer.valueOf(this.getDegreeOfParallelism())) + ") : " + this.getIdString();
    }

    public Client getClient() {
        return this.client;
    }

    public List<File> getJars() {
        return this.jarFilesToAttach;
    }

    static void setAsContext(Client client, List<File> jarFilesToAttach, ClassLoader userCodeClassLoader, int defaultParallelism) {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)new ContextEnvironmentFactory(client, jarFilesToAttach, userCodeClassLoader, defaultParallelism));
    }

    protected static void enableLocalExecution(boolean enabled) {
        ExecutionEnvironment.enableLocalExecution((boolean)enabled);
    }

    public static class ContextEnvironmentFactory
    implements ExecutionEnvironmentFactory {
        private final Client client;
        private final List<File> jarFilesToAttach;
        private final ClassLoader userCodeClassLoader;
        private final int defaultParallelism;

        public ContextEnvironmentFactory(Client client, List<File> jarFilesToAttach, ClassLoader userCodeClassLoader, int defaultParallelism) {
            this.client = client;
            this.jarFilesToAttach = jarFilesToAttach;
            this.userCodeClassLoader = userCodeClassLoader;
            this.defaultParallelism = defaultParallelism;
        }

        public ExecutionEnvironment createExecutionEnvironment() {
            ContextEnvironment env = new ContextEnvironment(this.client, this.jarFilesToAttach, this.userCodeClassLoader);
            if (this.defaultParallelism > 0) {
                env.setDegreeOfParallelism(this.defaultParallelism);
            }
            return env;
        }
    }
}

