/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.CliFrontend;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.StandaloneClusterDescriptor;
import org.apache.flink.client.program.StandaloneClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;

public class DefaultCLI
implements CustomCommandLine<StandaloneClusterClient> {
    @Override
    public boolean isActive(CommandLine commandLine, Configuration configuration) {
        return true;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
    }

    @Override
    public StandaloneClusterClient retrieveCluster(CommandLine commandLine, Configuration config) {
        if (commandLine.hasOption(CliFrontendParser.ADDRESS_OPTION.getOpt())) {
            String addressWithPort = commandLine.getOptionValue(CliFrontendParser.ADDRESS_OPTION.getOpt());
            InetSocketAddress jobManagerAddress = ClientUtils.parseHostPortAddress(addressWithPort);
            CliFrontend.setJobManagerAddressInConfig(config, jobManagerAddress);
        }
        if (commandLine.hasOption(CliFrontendParser.ZOOKEEPER_NAMESPACE_OPTION.getOpt())) {
            String zkNamespace = commandLine.getOptionValue(CliFrontendParser.ZOOKEEPER_NAMESPACE_OPTION.getOpt());
            config.setString(HighAvailabilityOptions.HA_CLUSTER_ID, zkNamespace);
        }
        StandaloneClusterDescriptor descriptor = new StandaloneClusterDescriptor(config);
        return descriptor.retrieve(null);
    }

    @Override
    public StandaloneClusterClient createCluster(String applicationName, CommandLine commandLine, Configuration config, List<URL> userJarFiles) throws UnsupportedOperationException {
        StandaloneClusterDescriptor descriptor = new StandaloneClusterDescriptor(config);
        return descriptor.deploy();
    }
}

