/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.costs;

import org.apache.flink.compiler.costs.CostEstimator;
import org.apache.flink.compiler.costs.Costs;
import org.apache.flink.compiler.dag.EstimateProvider;

public class DefaultCostEstimator
extends CostEstimator {
    private static final long HEURISTIC_COST_BASE = 1000000000L;
    private static final float MATERIALIZATION_CPU_FACTOR = 1.0f;
    private static final float HASHING_CPU_FACTOR = 4.0f;
    private static final float SORTING_CPU_FACTOR = 9.0f;

    @Override
    public void addRandomPartitioningCost(EstimateProvider estimates, Costs costs) {
        long estOutShipSize = estimates.getEstimatedOutputSize();
        if (estOutShipSize <= 0L) {
            costs.setNetworkCost(-1.0);
        } else {
            costs.addNetworkCost(estOutShipSize);
        }
        costs.addHeuristicNetworkCost(1.0E9);
    }

    @Override
    public void addHashPartitioningCost(EstimateProvider estimates, Costs costs) {
        long estOutShipSize = estimates.getEstimatedOutputSize();
        if (estOutShipSize <= 0L) {
            costs.setNetworkCost(-1.0);
        } else {
            costs.addNetworkCost(estOutShipSize);
        }
        costs.addHeuristicNetworkCost(1.0E9);
    }

    @Override
    public void addRangePartitionCost(EstimateProvider estimates, Costs costs) {
        long sampled;
        long dataSize = estimates.getEstimatedOutputSize();
        if (dataSize > 0L) {
            sampled = (long)((float)dataSize * 0.1f);
            costs.addNetworkCost(dataSize + sampled);
        } else {
            costs.setNetworkCost(-1.0);
        }
        sampled = 100000000L;
        costs.addHeuristicNetworkCost(1.1E9);
        costs.addHeuristicDiskCost(2.0E8);
    }

    @Override
    public void addBroadcastCost(EstimateProvider estimates, int replicationFactor, Costs costs) {
        if (replicationFactor <= 0) {
            throw new IllegalArgumentException("The replication factor of must be larger than zero.");
        }
        if (replicationFactor > 0) {
            long estOutShipSize = estimates.getEstimatedOutputSize();
            if (estOutShipSize <= 0L) {
                costs.setNetworkCost(-1.0);
            } else {
                costs.addNetworkCost((long)replicationFactor * estOutShipSize);
            }
            costs.addHeuristicNetworkCost(10000000000L * (long)replicationFactor);
        } else {
            costs.addHeuristicNetworkCost(1.0E12);
        }
    }

    @Override
    public void addFileInputCost(long fileSizeInBytes, Costs costs) {
        if (fileSizeInBytes >= 0L) {
            costs.addDiskCost(fileSizeInBytes);
        } else {
            costs.setDiskCost(-1.0);
        }
        costs.addHeuristicDiskCost(1.0E9);
    }

    @Override
    public void addLocalSortCost(EstimateProvider estimates, Costs costs) {
        long s = estimates.getEstimatedOutputSize();
        if (s <= 0L) {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        } else {
            costs.addDiskCost(2L * s);
            costs.addCpuCost((long)((float)s * 9.0f));
        }
        costs.addHeuristicDiskCost(2.0E9);
        costs.addHeuristicCpuCost(8.999999488E9);
    }

    @Override
    public void addLocalMergeCost(EstimateProvider input1, EstimateProvider input2, Costs costs, int costWeight) {
    }

    @Override
    public void addHybridHashCosts(EstimateProvider buildSideInput, EstimateProvider probeSideInput, Costs costs, int costWeight) {
        long bs = buildSideInput.getEstimatedOutputSize();
        long ps = probeSideInput.getEstimatedOutputSize();
        if (bs > 0L && ps > 0L) {
            long overall = 2L * bs + ps;
            costs.addDiskCost(overall);
            costs.addCpuCost((long)((float)overall * 4.0f));
        } else {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        }
        costs.addHeuristicDiskCost(2.0E9);
        costs.addHeuristicCpuCost(8.0E9);
        costs.multiplyWith(costWeight);
    }

    @Override
    public void addCachedHybridHashCosts(EstimateProvider buildSideInput, EstimateProvider probeSideInput, Costs costs, int costWeight) {
        if (costWeight < 1) {
            throw new IllegalArgumentException("The cost weight must be at least one.");
        }
        long bs = buildSideInput.getEstimatedOutputSize();
        long ps = probeSideInput.getEstimatedOutputSize();
        if (bs > 0L && ps > 0L) {
            long overall = 2L * bs + (long)costWeight * ps;
            costs.addDiskCost(overall);
            costs.addCpuCost((long)((float)overall * 4.0f));
        } else {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        }
        costs.addHeuristicDiskCost((long)(1 + costWeight) * 1000000000L);
        costs.addHeuristicCpuCost((long)((float)((long)(1 + costWeight) * 1000000000L) * 4.0f));
    }

    @Override
    public void addStreamedNestedLoopsCosts(EstimateProvider outerSide, EstimateProvider innerSide, long bufferSize, Costs costs, int costWeight) {
        long is = innerSide.getEstimatedOutputSize();
        long oc = outerSide.getEstimatedNumRecords();
        if (is > 0L && oc >= 0L) {
            if (is > bufferSize) {
                costs.addDiskCost(oc * is);
            }
            costs.addCpuCost((long)((float)(oc * is) * 1.0f));
        } else {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        }
        costs.addHeuristicDiskCost(1.0E14);
        costs.addHeuristicCpuCost(1.0E14f);
        costs.multiplyWith(costWeight);
    }

    @Override
    public void addBlockNestedLoopsCosts(EstimateProvider outerSide, EstimateProvider innerSide, long blockSize, Costs costs, int costWeight) {
        long is = innerSide.getEstimatedOutputSize();
        long os = outerSide.getEstimatedOutputSize();
        if (is > 0L && os > 0L) {
            long loops = Math.max(os / blockSize, 1L);
            costs.addDiskCost(loops * is);
            costs.addCpuCost((long)((float)(loops * is) * 1.0f));
        } else {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        }
        costs.addHeuristicDiskCost(1.0E12);
        costs.addHeuristicCpuCost(1.0E12f);
        costs.multiplyWith(costWeight);
    }

    @Override
    public void addArtificialDamCost(EstimateProvider estimates, long bufferSize, Costs costs) {
        long s = estimates.getEstimatedOutputSize();
        if (s <= 0L) {
            costs.setDiskCost(-1.0);
            costs.setCpuCost(-1.0);
        } else {
            costs.addDiskCost(2L * s);
            costs.setCpuCost((long)((float)s * 1.0f));
        }
        costs.addHeuristicDiskCost(2.0E9);
        costs.addHeuristicCpuCost(1.0E9);
    }
}

