/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.TwoInputNode;
import org.apache.flink.compiler.operators.CoGroupDescriptor;
import org.apache.flink.compiler.operators.CoGroupWithSolutionSetFirstDescriptor;
import org.apache.flink.compiler.operators.CoGroupWithSolutionSetSecondDescriptor;
import org.apache.flink.compiler.operators.OperatorDescriptorDual;

public class CoGroupNode
extends TwoInputNode {
    private List<OperatorDescriptorDual> dataProperties = this.initializeDataProperties();

    public CoGroupNode(CoGroupOperatorBase<?, ?, ?, ?> pactContract) {
        super((DualInputOperator<?, ?, ?, ?>)pactContract);
    }

    public CoGroupOperatorBase<?, ?, ?, ?> getPactContract() {
        return (CoGroupOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "CoGroup";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    public void makeCoGroupWithSolutionSet(int solutionsetInputIndex) {
        CoGroupDescriptor op;
        if (solutionsetInputIndex == 0) {
            op = new CoGroupWithSolutionSetFirstDescriptor(this.keys1, this.keys2);
        } else if (solutionsetInputIndex == 1) {
            op = new CoGroupWithSolutionSetSecondDescriptor(this.keys1, this.keys2);
        } else {
            throw new IllegalArgumentException();
        }
        this.dataProperties = Collections.singletonList(op);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    private List<OperatorDescriptorDual> initializeDataProperties() {
        Ordering groupOrder1 = null;
        Ordering groupOrder2 = null;
        CoGroupOperatorBase<?, ?, ?, ?> cgc = this.getPactContract();
        groupOrder1 = cgc.getGroupOrderForInputOne();
        groupOrder2 = cgc.getGroupOrderForInputTwo();
        if (groupOrder1 != null && groupOrder1.getNumberOfFields() == 0) {
            groupOrder1 = null;
        }
        if (groupOrder2 != null && groupOrder2.getNumberOfFields() == 0) {
            groupOrder2 = null;
        }
        return Collections.singletonList(new CoGroupDescriptor(this.keys1, this.keys2, groupOrder1, groupOrder2));
    }
}

