/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.dataproperties.RequestedGlobalProperties;
import org.apache.flink.compiler.dataproperties.RequestedLocalProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;

public class PartitionNode
extends SingleInputNode {
    public PartitionNode(PartitionOperatorBase<?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
    }

    public PartitionOperatorBase<?> getPactContract() {
        return (PartitionOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Partition";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return Collections.singletonList(new PartitionDescriptor(this.getPactContract().getPartitionMethod(), this.keys));
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return true;
    }

    public static class PartitionDescriptor
    extends OperatorDescriptorSingle {
        private final PartitionOperatorBase.PartitionMethod pMethod;
        private final FieldSet pKeys;

        public PartitionDescriptor(PartitionOperatorBase.PartitionMethod pMethod, FieldSet pKeys) {
            this.pMethod = pMethod;
            this.pKeys = pKeys;
        }

        @Override
        public DriverStrategy getStrategy() {
            return DriverStrategy.UNARY_NO_OP;
        }

        @Override
        public SingleInputPlanNode instantiate(Channel in, SingleInputNode node) {
            return new SingleInputPlanNode(node, "Partition", in, DriverStrategy.UNARY_NO_OP);
        }

        @Override
        protected List<RequestedGlobalProperties> createPossibleGlobalProperties() {
            RequestedGlobalProperties rgps = new RequestedGlobalProperties();
            switch (this.pMethod) {
                case HASH: {
                    rgps.setHashPartitioned((FieldSet)this.pKeys.toFieldList());
                    break;
                }
                case REBALANCE: {
                    rgps.setForceRebalancing();
                    break;
                }
                case RANGE: {
                    throw new UnsupportedOperationException("Not yet supported");
                }
                default: {
                    throw new IllegalArgumentException("Invalid partition method");
                }
            }
            return Collections.singletonList(rgps);
        }

        @Override
        protected List<RequestedLocalProperties> createPossibleLocalProperties() {
            return Collections.singletonList(new RequestedLocalProperties());
        }

        @Override
        public GlobalProperties computeGlobalProperties(GlobalProperties gProps) {
            return gProps;
        }

        @Override
        public LocalProperties computeLocalProperties(LocalProperties lProps) {
            return lProps;
        }
    }
}

