/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.costs.CostEstimator;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.PactConnection;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.InterestingProperties;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.dataproperties.RequestedGlobalProperties;
import org.apache.flink.compiler.dataproperties.RequestedLocalProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.NamedChannel;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.compiler.util.NoOpUnaryUdfOp;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.shaded.com.google.common.collect.Sets;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public abstract class SingleInputNode
extends OptimizerNode {
    protected final FieldSet keys;
    protected PactConnection inConn;

    protected SingleInputNode(SingleInputOperator<?, ?, ?> pactContract) {
        super((Operator<?>)pactContract);
        int[] k = pactContract.getKeyColumns(0);
        this.keys = k == null || k.length == 0 ? null : new FieldSet(k);
    }

    protected SingleInputNode(FieldSet keys) {
        super((Operator<?>)NoOpUnaryUdfOp.INSTANCE);
        this.keys = keys;
    }

    protected SingleInputNode() {
        super((Operator<?>)NoOpUnaryUdfOp.INSTANCE);
        this.keys = null;
    }

    protected SingleInputNode(SingleInputNode toCopy) {
        super(toCopy);
        this.keys = toCopy.keys;
    }

    public SingleInputOperator<?, ?, ?> getPactContract() {
        return (SingleInputOperator)super.getPactContract();
    }

    public PactConnection getIncomingConnection() {
        return this.inConn;
    }

    public void setIncomingConnection(PactConnection inConn) {
        this.inConn = inConn;
    }

    public OptimizerNode getPredecessorNode() {
        if (this.inConn != null) {
            return this.inConn.getSource();
        }
        return null;
    }

    @Override
    public List<PactConnection> getIncomingConnections() {
        return Collections.singletonList(this.inConn);
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        FieldSet fs;
        if (input != 0) {
            throw new IndexOutOfBoundsException();
        }
        SingleInputOperator<?, ?, ?> c = this.getPactContract();
        SingleInputSemanticProperties semanticProperties = c.getSemanticProperties();
        if (semanticProperties != null && (fs = semanticProperties.getForwardedField(fieldNumber)) != null) {
            return fs.contains(Integer.valueOf(fieldNumber));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode) throws CompilerException {
        ShipStrategyType preSet;
        Configuration conf = this.getPactContract().getParameters();
        String shipStrategy = conf.getString("INPUT_SHIP_STRATEGY", null);
        if (shipStrategy != null) {
            if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION_HASH")) {
                preSet = ShipStrategyType.PARTITION_HASH;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION_RANGE")) {
                preSet = ShipStrategyType.PARTITION_RANGE;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_FORWARD")) {
                preSet = ShipStrategyType.FORWARD;
            } else {
                if (!shipStrategy.equalsIgnoreCase("SHIP_REPARTITION")) throw new CompilerException("Unrecognized ship strategy hint: " + shipStrategy);
                preSet = ShipStrategyType.PARTITION_RANDOM;
            }
        } else {
            preSet = null;
        }
        Operator children = this.getPactContract().getInput();
        if (children == null) {
            throw new CompilerException("Error: Node for '" + this.getPactContract().getName() + "' has no input.");
        }
        OptimizerNode pred = contractToNode.get(children);
        PactConnection conn = new PactConnection(pred, this);
        if (preSet != null) {
            conn.setShipStrategy(preSet);
        }
        this.setIncomingConnection(conn);
        pred.addOutgoingConnection(conn);
    }

    protected abstract List<OperatorDescriptorSingle> getPossibleProperties();

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties props = this.getInterestingProperties().filterByCodeAnnotations(this, 0);
        for (OperatorDescriptorSingle dps : this.getPossibleProperties()) {
            for (RequestedGlobalProperties gp : dps.getPossibleGlobalProperties()) {
                props.addGlobalProperties(gp);
            }
            for (RequestedLocalProperties lp : dps.getPossibleLocalProperties()) {
                props.addLocalProperties(lp);
            }
        }
        this.inConn.setInterestingProperties(props);
        for (PactConnection conn : this.getBroadcastConnections()) {
            conn.setInterestingProperties(new InterestingProperties());
        }
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        Object c;
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        List<PlanNode> subPlans = this.getPredecessorNode().getAlternativePlans(estimator);
        Set<RequestedGlobalProperties> intGlobal = this.inConn.getInterestingProperties().getGlobalProperties();
        ArrayList<Set<? extends NamedChannel>> broadcastPlanChannels = new ArrayList<Set<? extends NamedChannel>>();
        List<PactConnection> broadcastConnections = this.getBroadcastConnections();
        List<String> broadcastConnectionNames = this.getBroadcastConnectionNames();
        for (int i = 0; i < broadcastConnections.size(); ++i) {
            PactConnection broadcastConnection = broadcastConnections.get(i);
            String broadcastConnectionName = broadcastConnectionNames.get(i);
            List<PlanNode> broadcastPlanCandidates = broadcastConnection.getSource().getAlternativePlans(estimator);
            HashSet<NamedChannel> broadcastChannels = new HashSet<NamedChannel>(broadcastPlanCandidates.size());
            for (PlanNode plan : broadcastPlanCandidates) {
                c = new NamedChannel(broadcastConnectionName, plan);
                ((Channel)c).setShipStrategy(ShipStrategyType.BROADCAST);
                broadcastChannels.add((NamedChannel)c);
            }
            broadcastPlanChannels.add(broadcastChannels);
        }
        HashSet<RequestedGlobalProperties> pairs = new HashSet<RequestedGlobalProperties>();
        for (OperatorDescriptorSingle ods : this.getPossibleProperties()) {
            pairs.addAll(ods.getPossibleGlobalProperties());
        }
        RequestedGlobalProperties[] allValidGlobals = pairs.toArray(new RequestedGlobalProperties[pairs.size()]);
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        int dop = this.getDegreeOfParallelism();
        int inDop = this.getPredecessorNode().getDegreeOfParallelism();
        boolean dopChange = inDop != dop;
        block3: for (PlanNode child : subPlans) {
            if (this.inConn.getShipStrategy() == null) {
                block4: for (RequestedGlobalProperties igps : intGlobal) {
                    Channel c2 = new Channel(child, this.inConn.getMaterializationMode());
                    igps.parameterizeChannel(c2, dopChange);
                    if (dopChange && !c2.getShipStrategy().isNetworkStrategy()) {
                        c2.getGlobalProperties().reset();
                    }
                    for (RequestedGlobalProperties rgps : allValidGlobals) {
                        if (!rgps.isMetBy(c2.getGlobalProperties())) continue;
                        c2.setRequiredGlobalProps(rgps);
                        this.addLocalCandidates(c2, broadcastPlanChannels, igps, outputPlans, estimator);
                        continue block4;
                    }
                }
                continue;
            }
            c = new Channel(child, this.inConn.getMaterializationMode());
            if (this.keys != null) {
                ((Channel)c).setShipStrategy(this.inConn.getShipStrategy(), this.keys.toFieldList());
            } else {
                ((Channel)c).setShipStrategy(this.inConn.getShipStrategy());
            }
            if (dopChange) {
                ((Channel)c).adjustGlobalPropertiesForFullParallelismChange();
            }
            for (RequestedGlobalProperties rgps : allValidGlobals) {
                if (!rgps.isMetBy(((Channel)c).getGlobalProperties())) continue;
                this.addLocalCandidates((Channel)c, broadcastPlanChannels, rgps, outputPlans, estimator);
                continue block3;
            }
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        outputPlans.trimToSize();
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    protected void addLocalCandidates(Channel template, List<Set<? extends NamedChannel>> broadcastPlanChannels, RequestedGlobalProperties rgps, List<PlanNode> target, CostEstimator estimator) {
        block0: for (RequestedLocalProperties ilp : this.inConn.getInterestingProperties().getLocalProperties()) {
            Channel in = template.clone();
            ilp.parameterizeChannel(in);
            for (OperatorDescriptorSingle dps : this.getPossibleProperties()) {
                for (RequestedLocalProperties ilps : dps.getPossibleLocalProperties()) {
                    if (!ilps.isMetBy(in.getLocalProperties())) continue;
                    in.setRequiredLocalProps(ilps);
                    this.instantiateCandidate(dps, in, broadcastPlanChannels, target, estimator, rgps, ilp);
                    continue block0;
                }
            }
        }
    }

    protected void instantiateCandidate(OperatorDescriptorSingle dps, Channel in, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReq, RequestedLocalProperties locPropsReq) {
        PlanNode inputSource = in.getSource();
        for (List broadcastChannelsCombination : Sets.cartesianProduct(broadcastPlanChannels)) {
            boolean validCombination = true;
            boolean requiresPipelinebreaker = false;
            block1: for (int i = 0; i < broadcastChannelsCombination.size(); ++i) {
                NamedChannel nc = (NamedChannel)broadcastChannelsCombination.get(i);
                PlanNode bcSource = nc.getSource();
                if (!this.areBranchCompatible(bcSource, inputSource)) {
                    validCombination = false;
                    break;
                }
                for (int k = 0; k < i; ++k) {
                    PlanNode otherBcSource = ((NamedChannel)broadcastChannelsCombination.get(k)).getSource();
                    if (this.areBranchCompatible(bcSource, otherBcSource)) continue;
                    validCombination = false;
                    break;
                }
                if (this.hereJoinedBranches == null) continue;
                for (OptimizerNode brancher : this.hereJoinedBranches) {
                    PlanNode candAtBrancher = in.getSource().getCandidateAtBranchPoint(brancher);
                    if (candAtBrancher == null) continue;
                    PlanNode.SourceAndDamReport res = in.getSource().hasDamOnPathDownTo(candAtBrancher);
                    if (res == PlanNode.SourceAndDamReport.NOT_FOUND) {
                        throw new CompilerException("Bug: Tracing dams for deadlock detection is broken.");
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
                        requiresPipelinebreaker = true;
                        continue block1;
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) continue;
                    throw new CompilerException();
                }
            }
            if (!validCombination) continue;
            if (requiresPipelinebreaker) {
                in.setTempMode(in.getTempMode().makePipelineBreaker());
            }
            SingleInputPlanNode node = dps.instantiate(in, this);
            node.setBroadcastInputs(broadcastChannelsCombination);
            GlobalProperties gProps = in.getGlobalProperties().clone();
            LocalProperties lProps = in.getLocalProperties().clone();
            gProps = dps.computeGlobalProperties(gProps);
            lProps = dps.computeLocalProperties(lProps);
            gProps = gProps.filterByNodesConstantSet(this, 0);
            lProps = lProps.filterByNodesConstantSet(this, 0);
            node.initProperties(gProps, lProps);
            node.updatePropertiesWithUniqueSets(this.getUniqueFields());
            target.add(node);
        }
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = this.getPredecessorNode().getBranchesForParent(this.inConn);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.computeUnclosedBranchStackForBroadcastInputs(fromInput);
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            if (this.getPredecessorNode() == null) {
                throw new CompilerException();
            }
            this.getPredecessorNode().accept(visitor);
            for (PactConnection connection : this.getBroadcastConnections()) {
                connection.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }
}

